/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.ai.provider;

import java.nio.file.Path;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * AI provider interface
 */
public interface AIProvider
{
    /**
     * Get the id of the provider
     * @return the id
     */
    public String getId();
    
    /**
     * Get the label of the provider
     * @return the label
     */
    public I18nizableText getLabel();
    
    /**
     * Summarized a text
     * @param text the text to summarize
     * @param maxLength the max number of characters that will be generated
     * @return the summarized text
     * @throws Exception if an error occurred during summarize process
     */
    public String textToSummary(String text, int maxLength) throws Exception;
    
    /**
     * Check if the image generation is supported
     * @return boolean true if the generation is enabled, false otherwise
     */
    public boolean isImageGenerationSupported();
    
    /**
     * Get the URL of the generated image
     * @param text the prompt text
     * @return the generated image
     * @throws Exception if an error occurred during the image generation
     */
    public Path textToImage(String text) throws Exception;
}
