/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.ai.provider.impl;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.TokenCountEstimator;

/**
 * Implementation of a default token count estimator. 1 token ~ 3 characters
 */
public class DefaultTokenCountEstimator implements TokenCountEstimator
{
    
    public int estimateTokenCountInText(String text)
    {
        return text.length() / 3;
    }

    public int estimateTokenCountInMessage(ChatMessage message)
    {
        String res = message.toString();
        return res.length() / 3;
    }

    public int estimateTokenCountInMessages(Iterable<ChatMessage> messages)
    {
        int res = 0;
        for (ChatMessage message : messages)
        {
            res += estimateTokenCountInMessage(message);
        }
        return res;
    }
}
