/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.JSONUtils;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Request;

public class CalendarCategoriesHelper
implements Component,
Serviceable {
    public static final String ROLE = CalendarCategoriesHelper.class.getName();
    protected static final String ZONEITEMID = "zoneItemId";
    protected static final String USER_PREF_ID = "plugin-calendar-categories";
    protected CurrentUserProvider _currentUserProvider;
    protected UserPreferencesManager _userPref;
    protected JSONUtils _jsonUtils;

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userPref = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public boolean setUserCategories(Request request) throws UserPreferencesException {
        UserIdentity identity = this._currentUserProvider.getUser();
        if (identity != null) {
            String siteName = WebHelper.getSiteName((Request)request);
            String zoneItemId = request.getParameter(ZONEITEMID);
            String categorieString = request.getParameter("categories");
            ArrayList<String> categories = new ArrayList<String>();
            if (categorieString != null) {
                categories.add(categorieString);
            } else {
                String[] categoriesString = request.getParameterValues("categories[]");
                categories.addAll(Arrays.asList(categoriesString));
            }
            return this.setUserCategories(identity, siteName, zoneItemId, categories);
        }
        return false;
    }

    public boolean setUserCategories(String siteName, String zoneItemId, List<String> categories) throws UserPreferencesException {
        UserIdentity identity = this._currentUserProvider.getUser();
        return this.setUserCategories(identity, siteName, zoneItemId, categories);
    }

    public boolean setUserCategories(UserIdentity identity, String siteName, String zoneItemId, List<String> categories) throws UserPreferencesException {
        if (identity == null) {
            return false;
        }
        String jsonCategories = this._jsonUtils.convertObjectToJson(categories);
        String jsonString = this._userPref.getUserPreferenceAsString(identity, "/sites/" + siteName, Collections.emptyMap(), USER_PREF_ID);
        HashMap<String, String> jsonMap = this._jsonUtils.convertJsonToMap(jsonString);
        if (jsonMap == null) {
            jsonMap = new HashMap<String, String>();
        }
        jsonMap.put(zoneItemId, jsonCategories);
        jsonString = this._jsonUtils.convertObjectToJson(jsonMap);
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(USER_PREF_ID, jsonString);
        this._userPref.setUserPreferences(identity, "/sites/" + siteName, Collections.emptyMap(), preferences);
        return true;
    }

    public List<String> getUserCategories(Request request) throws UserPreferencesException {
        UserIdentity identity = this._currentUserProvider.getUser();
        String siteName = WebHelper.getSiteName((Request)request);
        String zoneItemId = request.getParameter(ZONEITEMID);
        return this.getUserCategories(identity, siteName, zoneItemId);
    }

    public List<String> getUserCategories(String siteName, String zoneItemId) throws UserPreferencesException {
        UserIdentity identity = this._currentUserProvider.getUser();
        return this.getUserCategories(identity, siteName, zoneItemId);
    }

    public List<String> getUserCategories(UserIdentity identity, String siteName, String zoneItemId) throws UserPreferencesException {
        List<String> result = new ArrayList<String>();
        if (identity != null) {
            String jsonString = this._userPref.getUserPreferenceAsString(identity, "/sites/" + siteName, Collections.emptyMap(), USER_PREF_ID);
            Map jsonMap = this._jsonUtils.convertJsonToMap(jsonString);
            if (jsonMap != null && jsonMap.containsKey(zoneItemId)) {
                Object object = jsonMap.get(zoneItemId);
                if (object instanceof String) {
                    result = this._jsonUtils.convertJsonToList((String)object).stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
                } else if (object instanceof List) {
                    result = ((List)object).stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
                }
            } else {
                result.add("all");
            }
        } else {
            result.add("all");
        }
        return result;
    }
}

