/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.search;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.search.advanced.AbstractTreeNode;
import org.ametys.cms.search.advanced.TreeLeaf;
import org.ametys.cms.tag.CMSTag;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.calendar.icsreader.IcsEventHelper;
import org.ametys.plugins.calendar.search.CalendarSearchService;
import org.ametys.web.frontoffice.search.instance.SearchServiceInstance;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.frontoffice.search.requesttime.impl.SaxFormSearchComponent;
import org.ametys.web.frontoffice.search.requesttime.impl.SearchComponentHelper;
import org.ametys.web.frontoffice.search.requesttime.input.SearchUserInputs;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CalendarSaxFormSearchComponent
extends SaxFormSearchComponent {
    protected IcsEventHelper _icsEventHelper;
    protected TagProviderExtensionPoint _tagProviderEP;
    protected JSONUtils _jsonUtils;
    protected UserPreferencesManager _userPrefsManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._icsEventHelper = (IcsEventHelper)smanager.lookup(IcsEventHelper.ROLE);
        this._tagProviderEP = (TagProviderExtensionPoint)smanager.lookup(TagProviderExtensionPoint.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._userPrefsManager = (UserPreferencesManager)smanager.lookup(UserPreferencesManager.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    public boolean supports(SearchComponentArguments args) {
        return CalendarSearchService.isActive(args);
    }

    public void execute(SearchComponentArguments args) throws Exception {
        ContentHandler contentHandler = args.contentHandler();
        SearchServiceInstance serviceInstance = args.serviceInstance();
        List nonStaticCriteria = serviceInstance.getCriterionTree().map(AbstractTreeNode::getFlatLeaves).orElseGet(Collections::emptyList).stream().map(TreeLeaf::getValue).filter(c -> !c.getMode().isStatic()).collect(Collectors.toList());
        Parameters parameters = args.generatorParameters();
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"form");
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"fields");
        Map contextualParameters = SearchComponentHelper.getSearchComponentContextualParameters((SearchComponentArguments)args);
        this.saxFormFields(contentHandler, parameters, nonStaticCriteria, contextualParameters, serviceInstance.computeCriteriaCounts());
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"fields");
        SearchUserInputs userInputs = args.userInputs();
        Map userCriteria = userInputs.criteria();
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"values");
        this.saxFormValues(contentHandler, parameters, nonStaticCriteria, userCriteria);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"values");
        String zoneItemId = args.serviceInstance().getId();
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        if (CalendarSearchService.hasTagCategories(args.serviceInstance())) {
            List<String> categoryNames = CalendarSearchService.getTagCategories(serviceInstance);
            Set<Tag> tagCategories = this.getTagCategories(categoryNames, args);
            tagCategories.addAll(this._icsEventHelper.getIcsTags(zoneItem, args.currentSite().getName()));
            this.saxTagFacet(contentHandler, tagCategories, args);
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"form");
    }

    protected Set<Tag> getTagCategories(List<String> categoryNames, SearchComponentArguments args) {
        HashSet<Tag> tags = new HashSet<Tag>();
        if (categoryNames != null && !categoryNames.isEmpty()) {
            Map<String, String> params = Map.of("siteName", args.currentSite().getName());
            Set tagCategories = categoryNames.stream().map(c -> (CMSTag)this._tagProviderEP.getTag(c, params)).filter(Objects::nonNull).collect(Collectors.toSet());
            for (CMSTag cmsTag : tagCategories) {
                tags.addAll(this._getChildTags((Tag)cmsTag));
            }
        }
        return tags;
    }

    private Set<Tag> _getChildTags(Tag tag) {
        LinkedHashSet<Tag> allTags = new LinkedHashSet<Tag>();
        Map childTagsMap = tag.getTags();
        if (childTagsMap != null) {
            Collection childTags = childTagsMap.values();
            allTags.addAll(childTags);
            for (Tag child : childTags) {
                allTags.addAll(this._getChildTags(child));
            }
        }
        return allTags;
    }

    protected void saxTagFacet(ContentHandler handler, Collection<Tag> tags, SearchComponentArguments args) throws SAXException {
        HashSet<String> selectedTags = new HashSet<String>(CalendarSearchService.getSelectedTags(args));
        if (CalendarSearchService.saveUserPrefsEnabled(args) && CalendarSearchService.saveFilterInUserPrefs(args.serviceInstance())) {
            List<String> userTags = this._getCurrentSearchUserTagsFacet(args.serviceInstance().getId());
            selectedTags.addAll(userTags);
        }
        XMLUtils.startElement((ContentHandler)handler, (String)"tag-facet");
        for (Tag tag : tags) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("selected", String.valueOf(selectedTags.contains(tag.getName())));
            CalendarSearchService.saxTag(handler, attrs, tag);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"tag-facet");
    }

    protected List<String> _getCurrentSearchUserTagsFacet(String serviceId) {
        try {
            UserIdentity user = this._currentUserProvider.getUser();
            if (user != null) {
                Map userPreferences = this._userPrefsManager.getUnTypedUserPrefs(user, "calendar-search-" + serviceId, new HashMap());
                if (!userPreferences.isEmpty()) {
                    return this._jsonUtils.convertJsonToList((String)userPreferences.get("search.calendar.tags")).stream().filter(String.class::isInstance).map(String.class::cast).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                }
            } else {
                this.getLogger().debug("There is no authenticated user.");
            }
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("An error occured while getting the user preferences.", (Throwable)e);
        }
        return List.of();
    }
}

