/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.search;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ametys.cms.tag.ColorableTag;
import org.ametys.cms.tag.Tag;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.calendar.events.EventsFilterHelper;
import org.ametys.web.frontoffice.search.SearchService;
import org.ametys.web.frontoffice.search.instance.SearchServiceInstance;
import org.ametys.web.frontoffice.search.instance.model.RightCheckingMode;
import org.ametys.web.frontoffice.search.metamodel.AdditionalParameterValueMap;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CalendarSearchService
extends SearchService {
    public static final String SERVICE_ID = "org.ametys.plugins.calendar.SearchEvents";
    public static final String ENABLE_CALENDAR_PARAMETER_NAME = "calendar";
    public static final String SERVICE_PARAM_TAG_CATEGORIES = "tag-categories";
    public static final String SERVICE_PARAM_CONTENT_VIEW = "calendarContentView";
    public static final String SERVICE_PARAM_CONTENT_TYPES = "calendarContentTypes";
    public static final String SERVICE_PARAM_SAVE_USER_PREFS = "saveFilterInUserPrefs";
    public static final String PARAM_START_DATE = "start";
    public static final String PARAM_END_DATE = "end";
    public static final String PARAM_TAGS = "tags";
    public static final String PARAM_SUBMIT = "submit-form";
    public static final String START_DATE_ATTRIBUTE_NAME = "start-date";
    public static final String END_DATE_ATTRIBUTE_NAME = "end-date";
    private static final String __TAGS_ALL_VALUE = "_ALL";
    private static final String __ENABLE_SAVE_USER_PREFS_PARAMETER_NAME = "saveUserPrefs";

    public boolean isCacheable(Page currentPage, ZoneItem zoneItem) {
        boolean isDebug = this._isDebug(ContextHelper.getRequest((Context)this._context), this._renderingContextHandler);
        SearchServiceInstance serviceInstance = this._searchServiceInstanceManager.get(zoneItem.getId());
        if (!isDebug) {
            return !CalendarSearchService._hasUserInput((SearchServiceInstance)serviceInstance) && serviceInstance.getRightCheckingMode() != RightCheckingMode.EXACT && !CalendarSearchService.hasTagCategories(serviceInstance);
        }
        return false;
    }

    public static boolean hasTagCategories(SearchServiceInstance serviceInstance) {
        List<String> categoryNames = CalendarSearchService.getTagCategories(serviceInstance);
        return categoryNames != null && !categoryNames.isEmpty();
    }

    public static List<String> getTagCategories(SearchServiceInstance serviceInstance) {
        AdditionalParameterValueMap additionalParameterValues = serviceInstance.getAdditionalParameterValues();
        return (List)additionalParameterValues.getValue(SERVICE_PARAM_TAG_CATEGORIES);
    }

    public static boolean saveUserPrefsEnabled(SearchComponentArguments args) {
        return args.generatorParameters().getParameterAsBoolean(__ENABLE_SAVE_USER_PREFS_PARAMETER_NAME, true);
    }

    public static boolean saveFilterInUserPrefs(SearchServiceInstance serviceInstance) {
        AdditionalParameterValueMap additionalParameterValues = serviceInstance.getAdditionalParameterValues();
        return (Boolean)additionalParameterValues.getValue(SERVICE_PARAM_SAVE_USER_PREFS);
    }

    public static List<String> getSelectedTags(SearchComponentArguments args) {
        String parameter = args.generatorParameters().getParameter(PARAM_TAGS, "");
        if (__TAGS_ALL_VALUE.equals(parameter)) {
            return List.of();
        }
        String[] selectedTags = StringUtils.isNotEmpty((CharSequence)parameter) ? parameter.split(",") : new String[]{};
        return Arrays.asList(selectedTags);
    }

    public static boolean isActive(SearchComponentArguments args) {
        return args.generatorParameters().getParameterAsBoolean(ENABLE_CALENDAR_PARAMETER_NAME, false);
    }

    public static boolean isFormSubmit(SearchComponentArguments args) {
        return args.generatorParameters().getParameterAsBoolean(PARAM_SUBMIT, false);
    }

    public static EventsFilterHelper.DateTimeRange getDateRange(SearchComponentArguments args) {
        Parameters parameters = args.generatorParameters();
        if (parameters.isParameter(PARAM_START_DATE) && parameters.isParameter(PARAM_END_DATE)) {
            try {
                String start = URIUtils.decode((String)parameters.getParameter(PARAM_START_DATE));
                String end = URIUtils.decode((String)parameters.getParameter(PARAM_END_DATE));
                ZonedDateTime fromDateTime = DateUtils.parseZonedDateTime((String)start);
                ZonedDateTime untilDateTime = DateUtils.parseZonedDateTime((String)end);
                return new EventsFilterHelper.DateTimeRange(fromDateTime, untilDateTime);
            }
            catch (ParameterException parameterException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void saxTag(ContentHandler handler, Tag tag) throws SAXException {
        CalendarSearchService.saxTag(handler, new AttributesImpl(), tag);
    }

    public static void saxTag(ContentHandler handler, AttributesImpl attrs, Tag tag) throws SAXException {
        if (tag != null) {
            attrs.addCDATAAttribute("name", tag.getName());
            XMLUtils.startElement((ContentHandler)handler, (String)"tag", (Attributes)attrs);
            XMLUtils.startElement((ContentHandler)handler, (String)"label");
            tag.getTitle().toSAX(handler);
            XMLUtils.endElement((ContentHandler)handler, (String)"label");
            CalendarSearchService.saxTagColor(handler, tag);
            XMLUtils.endElement((ContentHandler)handler, (String)"tag");
        }
    }

    public static void saxTagColor(ContentHandler handler, Tag tag) throws SAXException {
        if (tag instanceof ColorableTag) {
            String colorIndex = ((ColorableTag)tag).getColor(true);
            Map colors = (Map)((ColorableTag)tag).getColorComponent().getColors().get(colorIndex);
            if (colors != null) {
                XMLUtils.startElement((ContentHandler)handler, (String)"color");
                for (Map.Entry entry : colors.entrySet()) {
                    XMLUtils.createElement((ContentHandler)handler, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"color");
            }
        }
    }
}

