/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.calendar.search;

import java.util.HashMap;
import java.util.List;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.calendar.search.CalendarSearchService;
import org.ametys.web.frontoffice.search.requesttime.AbstractSearchComponent;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SaveUserPrefsSearchComponent
extends AbstractSearchComponent
implements Serviceable {
    protected JSONUtils _jsonUtils;
    protected UserPreferencesManager _userPrefsManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._userPrefsManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE);
    }

    public int getPriority() {
        return -2147483148;
    }

    public boolean supports(SearchComponentArguments args) {
        return CalendarSearchService.isFormSubmit(args) && CalendarSearchService.saveUserPrefsEnabled(args) && CalendarSearchService.isActive(args) && CalendarSearchService.hasTagCategories(args.serviceInstance()) && CalendarSearchService.saveFilterInUserPrefs(args.serviceInstance());
    }

    public void execute(SearchComponentArguments args) throws Exception {
        UserIdentity currentUser = this._currentUserProvider.getUser();
        if (currentUser != null) {
            List<String> selectedTags = CalendarSearchService.getSelectedTags(args);
            String serviceId = args.serviceInstance().getId();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("search.calendar.tags", this._jsonUtils.convertObjectToJson(selectedTags));
            this._userPrefsManager.setUserPreferences(currentUser, "calendar-search-" + serviceId, new HashMap(), values);
        }
    }
}

