/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.cart;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.cms.data.ametysobject.ModifiableModelAwareDataAwareAmetysObject;
import org.ametys.cms.data.holder.ModifiableIndexableDataHolder;
import org.ametys.cms.data.holder.group.ModifiableIndexableRepeater;
import org.ametys.cms.data.holder.impl.DefaultModifiableModelAwareDataHolder;
import org.ametys.cms.indexing.solr.SolrAclCacheUninfluentialObject;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.cart.CartElement;
import org.ametys.plugins.cart.CartFactory;
import org.ametys.plugins.cart.ContentElement;
import org.ametys.plugins.cart.QueryElement;
import org.ametys.plugins.cart.QueryFromDirectoryElement;
import org.ametys.plugins.cart.ResourceElement;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.queriesdirectory.Query;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.data.holder.group.ModifiableModelAwareRepeaterEntry;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.DefaultAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultAmetysObjectFactory;
import org.ametys.runtime.model.ModelItemContainer;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SolrAclCacheUninfluentialObject
public class Cart
extends DefaultAmetysObject<CartFactory>
implements ModifiableModelAwareDataAwareAmetysObject {
    public static final String TITLE = "label";
    public static final String DESCRIPTION = "description";
    public static final String DOCUMENTATION = "documentation";
    public static final String AUTHOR = "author";
    public static final String CONTRIBUTOR = "contributor";
    public static final String CREATIONDATE = "creationDate";
    public static final String LASTMODIFICATIONDATE = "lastModificationDate";
    public static final String CONTENT_CART_ELEMENTS = "contents";
    public static final String RESOURCE_CART_ELEMENTS = "resources";
    public static final String QUERIES_CART_ELEMENTS = "queries";
    public static final String QUERIES_FROM_DIRECTORY_CART_ELEMENTS = "queries-from-directory";
    public static final String QUERY_ID_PROPERTY = "id";
    public static final String QUERY_DESCRIPTION_PROPERTY = "description";
    public static final String QUERY_AUTHOR_PROPERTY = "author";
    public static final String QUERY_TITLE_PROPERTY = "title";
    public static final String QUERY_DATE_PROPERTY = "date";
    private static Logger _logger = LoggerFactory.getLogger((String)Cart.class.getName());

    public Cart(Node node, String parentPath, CartFactory factory) {
        super(node, parentPath, (DefaultAmetysObjectFactory)factory);
    }

    public void setTitle(String title) {
        this.setValue(TITLE, title);
    }

    public void setDescription(String description) {
        this.setValue("description", description);
    }

    public void setDocumentation(String documentation) {
        this.setValue(DOCUMENTATION, documentation);
    }

    public void setAuthor(UserIdentity author) {
        this.setValue("author", author);
    }

    public void setContributor(UserIdentity contributor) {
        this.setValue(CONTRIBUTOR, contributor);
    }

    public void setCreationDate(ZonedDateTime creationDate) {
        this.setValue(CREATIONDATE, creationDate);
    }

    public void setLastModificationDate(ZonedDateTime lastModificationDate) {
        this.setValue(LASTMODIFICATIONDATE, lastModificationDate);
    }

    public String getTitle() {
        return (String)this.getValue(TITLE);
    }

    public String getDescription() {
        return (String)this.getValue("description");
    }

    public String getDocumentation() {
        return (String)this.getValue(DOCUMENTATION);
    }

    public UserIdentity getAuthor() {
        return (UserIdentity)this.getValue("author");
    }

    public UserIdentity getContributor() {
        return (UserIdentity)this.getValue(CONTRIBUTOR);
    }

    public ZonedDateTime getCreationDate() {
        return (ZonedDateTime)this.getValue(CREATIONDATE);
    }

    public ZonedDateTime getLastModificationDate() {
        return (ZonedDateTime)this.getValue(LASTMODIFICATIONDATE);
    }

    public void addContent(String contentId) {
        this._addElementToCart(contentId, CONTENT_CART_ELEMENTS);
    }

    public void addResource(String resourceId) {
        this._addElementToCart(resourceId, RESOURCE_CART_ELEMENTS);
    }

    public void addQueryFormDirectory(String queryId) {
        this._addElementToCart(queryId, QUERIES_FROM_DIRECTORY_CART_ELEMENTS);
    }

    private void _addElementToCart(String elementId, String attributePath) {
        String[] elmtArray = (String[])this.getValue(attributePath, false, new String[0]);
        HashSet<String> elmts = new HashSet<String>();
        Collections.addAll(elmts, elmtArray);
        elmts.add(elementId);
        this.setValue(attributePath, elmts.toArray(new String[elmts.size()]));
    }

    public void addQuery(UserIdentity author, String title, String description) {
        this.addQuery(StringUtils.generateKey(), author, title, description, ZonedDateTime.now());
    }

    public void addQuery(String id, UserIdentity author, String title, String description, ZonedDateTime date) {
        ModifiableIndexableRepeater queries = this.getRepeater(QUERIES_CART_ELEMENTS, true);
        ModifiableModelAwareRepeaterEntry query = queries.addEntry();
        query.setValue(QUERY_ID_PROPERTY, (Object)id);
        query.setValue(QUERY_TITLE_PROPERTY, (Object)title);
        query.setValue("description", (Object)description);
        query.setValue("author", (Object)author);
        query.setValue(QUERY_DATE_PROPERTY, (Object)date);
    }

    public void removeElement(String elmtId, CartElementType elmtType) {
        switch (elmtType.ordinal()) {
            case 0: {
                this._removeContent(elmtId);
                break;
            }
            case 1: {
                this._removeResource(elmtId);
                break;
            }
            case 2: {
                this._removeQuery(elmtId);
                break;
            }
            case 3: {
                this._removeQueryFromDirectory(elmtId);
                break;
            }
        }
    }

    protected void _removeResource(String resourceIdToRemove) {
        this._removeElementFromCart(resourceIdToRemove, RESOURCE_CART_ELEMENTS);
    }

    protected void _removeContent(String contentIdToRemove) {
        this._removeElementFromCart(contentIdToRemove, CONTENT_CART_ELEMENTS);
    }

    protected void _removeQueryFromDirectory(String queryIdToRemove) {
        this._removeElementFromCart(queryIdToRemove, QUERIES_FROM_DIRECTORY_CART_ELEMENTS);
    }

    private void _removeElementFromCart(String elementId, String attributePath) {
        Object[] elements = (String[])this.getValue(attributePath, false, new String[0]);
        elements = (String[])ArrayUtils.removeElement((Object[])elements, (Object)elementId);
        this.setValue(attributePath, elements);
    }

    protected void _removeQuery(String queryIdToRemove) {
        ModifiableIndexableRepeater queries = this.getRepeater(QUERIES_CART_ELEMENTS, true);
        ModifiableModelAwareRepeaterEntry entryToRemove = queries.getEntries().stream().filter(entry -> entry.getValue(QUERY_ID_PROPERTY).equals(queryIdToRemove)).findFirst().orElse(null);
        if (entryToRemove != null) {
            queries.removeEntry(entryToRemove.getPosition());
        }
    }

    public List<CartElement> getElements() {
        ArrayList<CartElement> elmts = new ArrayList<CartElement>();
        try {
            elmts.addAll(this.getContentCartElements());
            elmts.addAll(this.getResourceCartElements());
            elmts.addAll(this.getQueryCartElements());
            elmts.addAll(this.getQueryFromDirectoryCartElements());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error while getting cart elements", (Throwable)e);
        }
        return elmts;
    }

    public List<ContentElement> getContentCartElements() throws RepositoryException {
        ArrayList<String> unexistingElmts = new ArrayList<String>();
        ArrayList<ContentElement> elmts = new ArrayList<ContentElement>();
        String[] contents = (String[])this.getValue(CONTENT_CART_ELEMENTS, false, new String[0]);
        for (String contentId : contents) {
            try {
                Content content = (Content)((CartFactory)this._getFactory()).getResolver().resolveById(contentId);
                elmts.add(new ContentElement(content, ((CartFactory)this._getFactory())._getContentTypesHelper(), ((CartFactory)this._getFactory())._getContentTypeEP()));
            }
            catch (UnknownAmetysObjectException e) {
                _logger.error("The content of id '{}' does not exist anymore. It will be deleting from cart '{}'.", (Object)contentId, (Object)this.getId());
                unexistingElmts.add(contentId);
            }
        }
        for (String contentId : unexistingElmts) {
            this._removeContent(contentId);
        }
        return elmts;
    }

    public List<ResourceElement> getResourceCartElements() throws RepositoryException {
        ArrayList<String> unexistingElmts = new ArrayList<String>();
        ArrayList<ResourceElement> elmts = new ArrayList<ResourceElement>();
        String[] resources = (String[])this.getValue(RESOURCE_CART_ELEMENTS, false, new String[0]);
        for (String resourceId : resources) {
            try {
                Resource resource = (Resource)((CartFactory)this._getFactory()).getResolver().resolveById(resourceId);
                elmts.add(new ResourceElement(resource));
            }
            catch (UnknownAmetysObjectException e) {
                _logger.error("The resource of id '{}' does not exist anymore. It will be deleting from cart '{}'.", (Object)resourceId, (Object)this.getId());
                unexistingElmts.add(resourceId);
            }
        }
        for (String resourceId : unexistingElmts) {
            this._removeResource(resourceId);
        }
        return elmts;
    }

    public List<QueryFromDirectoryElement> getQueryFromDirectoryCartElements() throws RepositoryException {
        ArrayList<String> unexistingElmts = new ArrayList<String>();
        ArrayList<QueryFromDirectoryElement> elmts = new ArrayList<QueryFromDirectoryElement>();
        String[] queries = (String[])this.getValue(QUERIES_FROM_DIRECTORY_CART_ELEMENTS, false, new String[0]);
        for (String queryId : queries) {
            try {
                Query query = (Query)((CartFactory)this._getFactory()).getResolver().resolveById(queryId);
                elmts.add(new QueryFromDirectoryElement(query));
            }
            catch (UnknownAmetysObjectException e) {
                _logger.error("The query of id '{}' does not exist anymore. It will be deleting from cart '{}'.", (Object)queryId, (Object)this.getId());
                unexistingElmts.add(queryId);
            }
        }
        for (String queryId : unexistingElmts) {
            this._removeQueryFromDirectory(queryId);
        }
        return elmts;
    }

    public boolean hasQueryFromDirectoryCartElement(String queryId) {
        Object[] queries = (String[])this.getValue(QUERIES_FROM_DIRECTORY_CART_ELEMENTS, false, new String[0]);
        return ArrayUtils.contains((Object[])queries, (Object)queryId);
    }

    public List<QueryElement> getQueryCartElements() throws RepositoryException {
        ModifiableIndexableRepeater queries = this.getRepeater(QUERIES_CART_ELEMENTS, true);
        List<QueryElement> elmts = queries.getEntries().stream().map(entry -> {
            String id = (String)entry.getValue(QUERY_ID_PROPERTY);
            UserIdentity author = (UserIdentity)entry.getValue("author");
            String query = (String)entry.getValue("description");
            String title = (String)entry.getValue(QUERY_TITLE_PROPERTY);
            ZonedDateTime creationDate = (ZonedDateTime)entry.getValue(QUERY_DATE_PROPERTY);
            return new QueryElement(id, query, author, creationDate, author, creationDate, title);
        }).collect(Collectors.toList());
        return elmts;
    }

    public ModifiableIndexableDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelAwareDataHolder((ModifiableRepositoryData)repositoryData, (ModelItemContainer)((CartFactory)this._getFactory()).getModel());
    }

    public static enum CartElementType {
        CONTENT,
        RESOURCE,
        CARTQUERY,
        CARTQUERYFROMDIRECTORY;

    }

    public static enum CartProfile {
        READ_ACCESS,
        WRITE_ACCESS,
        RIGHT_ACCESS;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

