/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.cart;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.cart.CartElement;
import org.ametys.runtime.i18n.I18nizableText;

public class ContentElement
implements CartElement {
    private Content _content;
    private ContentTypesHelper _cTypesHelper;
    private ContentTypeExtensionPoint _cTypesEP;

    public ContentElement(Content content, ContentTypesHelper cTypesHelper, ContentTypeExtensionPoint cTypesEP) {
        this._content = content;
        this._cTypesHelper = cTypesHelper;
        this._cTypesEP = cTypesEP;
    }

    @Override
    public String getId() {
        return this._content.getId();
    }

    @Override
    public I18nizableText getTitle() {
        return new I18nizableText(this._content.getTitle());
    }

    @Override
    public I18nizableText getDescription() {
        return new I18nizableText("");
    }

    @Override
    public List<I18nizableText> getGroups() {
        ArrayList<I18nizableText> cTypesLabel = new ArrayList<I18nizableText>();
        for (String cTypeId : this._content.getTypes()) {
            cTypesLabel.add(((ContentType)this._cTypesEP.getExtension(cTypeId)).getLabel());
        }
        return cTypesLabel;
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return this._content.getCreationDate();
    }

    @Override
    public UserIdentity getCreator() {
        return this._content.getCreator();
    }

    @Override
    public ZonedDateTime getLastModified() {
        return this._content.getLastModified();
    }

    @Override
    public UserIdentity getLastContributor() {
        return this._content.getLastContributor();
    }

    @Override
    public String getType() {
        return "content";
    }

    @Override
    public String getGlyphIcon() {
        return this._cTypesHelper.getIconGlyph(this._content);
    }

    @Override
    public String getSmallIcon() {
        return this._cTypesHelper.getSmallIcon(this._content);
    }

    @Override
    public String getMediumIcon() {
        return this._cTypesHelper.getMediumIcon(this._content);
    }

    public Content getContent() {
        return this._content;
    }
}

