/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.cart.accesscontroller;

import java.util.Map;
import java.util.Set;
import org.ametys.core.right.RightsException;
import org.ametys.plugins.cart.Cart;
import org.ametys.plugins.cart.CartContainer;
import org.ametys.plugins.cart.CartHelper;
import org.ametys.plugins.core.impl.right.AbstractHierarchicalAccessController;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class CartAccessController
extends AbstractHierarchicalAccessController<AmetysObject> {
    public static final I18nizableText CART_CONTEXT_CATEGORY = new I18nizableText("plugin.cart", "PLUGINS_CART_RIGHTS_CATEGORY");
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean supports(Object object) {
        return object instanceof Cart || object instanceof CartContainer;
    }

    protected Set<AmetysObject> _getParents(AmetysObject object) {
        if (object instanceof Cart) {
            return Set.of(object.getParent());
        }
        return null;
    }

    protected boolean ignoreOnHasAnyPermission() {
        return true;
    }

    protected Set<? extends Object> _convertWorkspaceToRootRightContexts(Set<Object> workspacesContexts) {
        if (workspacesContexts.contains("/cms")) {
            return Set.of(CartHelper.getCartsNode(this._resolver));
        }
        return null;
    }

    protected I18nizableText getObjectLabelForExplanation(Object object) throws RightsException {
        if (object instanceof Cart) {
            Map<String, I18nizableText> params = Map.of("title", this.getObjectLabel(object));
            return new I18nizableText("plugin.cart", "PLUGINS_CART_ACCESS_CONTROLLER_CONTEXT_EXPLANATION_LABEL", params);
        }
        if (object instanceof CartContainer) {
            return new I18nizableText("plugin.cart", "PLUGINS_CART_ACCESS_CONTROLLER_ROOT_CONTEXT_EXPLANATION_LABEL");
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Cart) {
            Cart cart = (Cart)((Object)object);
            return new I18nizableText(cart.getTitle());
        }
        if (object instanceof CartContainer) {
            return new I18nizableText("plugin.cart", "PLUGINS_CART_ACCESS_CONTROLLER_ROOT_CONTEXT_LABEL");
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return CART_CONTEXT_CATEGORY;
    }

    public int getObjectPriority(Object object) {
        if (CartHelper.getCartsNode(this._resolver).equals(object)) {
            return 10;
        }
        return super.getObjectPriority(object);
    }
}

