/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.cart.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.cart.Cart;
import org.ametys.plugins.cart.CartsDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetCartsAction
extends ServiceableAction {
    private CurrentUserProvider _userProvider;
    private AmetysObjectResolver _resolver;
    private CartsDAO _cartDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._cartDAO = (CartsDAO)serviceManager.lookup(CartsDAO.ROLE);
        this._userProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Predicate<Cart> filterCarts;
        Map jsParameters = (Map)objectModel.get("parent-context");
        String profileId = (String)StringUtils.defaultIfEmpty((CharSequence)((String)jsParameters.get("profile")), (CharSequence)"read_access");
        List<Object> nodes = new ArrayList();
        if (!("read_access".equals(profileId) || "write_access".equals(profileId) || "right_access".equals(profileId))) {
            throw new IllegalArgumentException("Unexpected profile identifier : " + profileId);
        }
        Cart.CartProfile profile = Cart.CartProfile.valueOf(profileId.toUpperCase());
        UserIdentity identity = this._userProvider.getUser();
        switch (profile) {
            case WRITE_ACCESS: {
                filterCarts = cart -> this._cartDAO.canWrite(identity, (Cart)((Object)cart));
                break;
            }
            case RIGHT_ACCESS: {
                filterCarts = cart -> this._cartDAO.canAssignRights(identity, (Cart)((Object)cart));
                break;
            }
            default: {
                filterCarts = cart -> this._cartDAO.canRead(identity, (Cart)((Object)cart));
            }
        }
        nodes = this._resolver.query("//element(*, ametys:cart)").stream().filter(Cart.class::isInstance).map(obj -> (Cart)((Object)obj)).filter(filterCarts).map(cart -> this._cartDAO.getCartProperties((Cart)((Object)cart))).collect(Collectors.toList());
        HashMap result = new HashMap();
        result.put("carts", nodes);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

