/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.cart.generators;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.cart.Cart;
import org.ametys.plugins.cart.CartElement;
import org.ametys.plugins.cart.CartsDAO;
import org.ametys.plugins.cart.ContentElement;
import org.ametys.plugins.cart.QueryElement;
import org.ametys.plugins.cart.ResourceElement;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CartElementDetailsGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _resolver;
    protected CurrentUserProvider _userProvider;
    private JSONUtils _jsonUtils;
    private SourceResolver _sourceResolver;
    private UserManager _userManager;
    private CartsDAO _cartsDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._jsonUtils = (JSONUtils)this.manager.lookup(JSONUtils.ROLE);
        this._sourceResolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._userProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._cartsDAO = (CartsDAO)smanager.lookup(CartsDAO.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String id = request.getParameter("cartId");
        Cart cart = (Cart)this._resolver.resolveById(id);
        UserIdentity user = this._userProvider.getUser();
        this.contentHandler.startDocument();
        if (this._cartsDAO.canRead(user, cart)) {
            List<QueryElement> queries;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", cart.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"cart", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)cart.getTitle());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)cart.getDescription());
            try {
                queries = cart.getQueryCartElements();
                this._saxQueries(queries);
            }
            catch (Exception e) {
                throw new SAXException("Unable to sax queries", e);
            }
            try {
                queries = cart.getQueryFromDirectoryCartElements();
                this._saxQueries(queries);
            }
            catch (Exception e) {
                throw new SAXException("Unable to sax queries", e);
            }
            try {
                List<ContentElement> contents = cart.getContentCartElements();
                this._saxContents(contents);
            }
            catch (Exception e) {
                throw new SAXException("Unable to sax contents", e);
            }
            try {
                List<ResourceElement> resources = cart.getResourceCartElements();
                this._saxResources(resources);
            }
            catch (Exception e) {
                throw new SAXException("Unable to sax resources", e);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"cart");
        } else {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"not-allowed");
        }
        this.contentHandler.endDocument();
    }

    protected void _saxResources(List<ResourceElement> resources) throws IOException, SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"resources");
        for (ResourceElement resource : resources) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", resource.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"resource", (Attributes)attrs);
            this._saxCartElement(resource, resource.getGroups().get(0));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"resource");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"resources");
    }

    protected void _saxCartElement(CartElement cartElement, I18nizableText group) throws SAXException {
        cartElement.getTitle().toSAX(this.contentHandler, "title");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"creation", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)cartElement.getCreationDate()));
        UserIdentity creatorIdentity = cartElement.getCreator();
        User creator = this._userManager.getUser(creatorIdentity);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"creator", (String)(creator != null ? creator.getFullName() : ""));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"lastModification", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)cartElement.getLastModified()));
        UserIdentity lastContributorIdentity = cartElement.getLastContributor();
        User lastContributor = this._userManager.getUser(lastContributorIdentity.getPopulationId(), lastContributorIdentity.getLogin());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"lastContributor", (String)(lastContributor != null ? lastContributor.getFullName() : ""));
        group.toSAX(this.contentHandler, "group");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _saxContents(List<ContentElement> contents) throws IOException, SAXException {
        SitemapSource sitemapSource = null;
        try {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"contents");
            for (ContentElement content : contents) {
                List<I18nizableText> groups = content.getGroups();
                for (I18nizableText group : groups) {
                    XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"content");
                    this._saxCartElement(content, group);
                    String cocoonUrl = this._contentToCocoonUrl(content);
                    sitemapSource = (SitemapSource)this._sourceResolver.resolveURI(cocoonUrl);
                    sitemapSource.toSAX((ContentHandler)new IgnoreRootHandler(this.contentHandler));
                    XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"content");
                }
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"contents");
        }
        finally {
            this.resolver.release(sitemapSource);
        }
    }

    protected String _contentToCocoonUrl(ContentElement content) {
        return "cocoon://_content.html?contentId=" + URIUtils.encodeParameter((String)content.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _saxQueries(List<? extends QueryElement> queries) throws IOException, SAXException {
        SitemapSource sitemapSource = null;
        try {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"queries");
            for (QueryElement queryElement : queries) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"query");
                this._saxCartElement(queryElement, queryElement.getGroups().get(0));
                String queryContent = queryElement.getQueryContent();
                Map queryDetails = this._jsonUtils.convertJsonToMap(queryContent);
                String printPluginUrl = queryDetails.containsKey("printUrlPlugin") ? (String)queryDetails.get("printUrlPlugin") : "cms";
                String printUrl = queryDetails.containsKey("printUrl") ? (String)queryDetails.get("printUrl") : "search/print.html";
                Map exportParams = (Map)queryDetails.get("exportParams");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("parameters", this._jsonUtils.convertObjectToJson((Object)exportParams));
                sitemapSource = (SitemapSource)this._sourceResolver.resolveURI("cocoon://_plugins/" + printPluginUrl + "/" + printUrl + "?parameters=" + this._jsonUtils.convertObjectToJson((Object)exportParams), null, new HashMap());
                sitemapSource.toSAX((ContentHandler)new IgnoreRootHandler(this.contentHandler));
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"query");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"queries");
        }
        finally {
            this.resolver.release(sitemapSource);
        }
    }
}

