/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a read-only input representing the value of current selected cart's id
 * @private
 */
Ext.define('Ametys.plugins.cart.controllers.CartIdentifierController', {
	extend: 'Ametys.ribbon.element.ui.FieldController',
	
	constructor: function (config)
	{
		this.callParent(arguments);
		
		Ametys.message.MessageBus.on(Ametys.message.Message.SELECTION_CHANGED, this._onSelectionChanged, this);
	},
	
	/**
	 * Listener on selection changed event
	 * @param {Ametys.message.Message} message The selection message
	 * @private
	 */
	_onSelectionChanged: function(message)
	{
		message = message || Ametys.message.MessageBus.getCurrentSelectionMessage();
		
		var target = message.getTarget(Ametys.message.MessageTarget.CART);
		
		if (target != null)
		{
            this.setDisabled(false);
            this.setAdditionalDescription(null);
			this.setValue(target.getParameters().id);
		}
		else
		{
            this.setDisabled(true);
			this.setValue();
            this.setAdditionalDescription("{{i18n PLUGINS_CART_CART_IDENTIFIER_NO_SELECTION}}");
		}
		
	}
});

