/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


/**
 * This class is the data model for cart entries.
 * @private
 */
Ext.define('Ametys.plugins.cart.tool.CartsTool.CartEntry', {
	extend: 'Ext.data.Model',
	
	fields: [
		'id',
		{name: 'title', type: 'string'},
		{name: 'description', type: 'string'},
        {name: 'documentation', type:'string'},
        {name: 'lastModificationDate', type:'date', dateFormat:'c'},
        {name: 'creationDate', type:'date', dateFormat:'c'},
        'author',
        {
            name: 'authorFullName', 
            type: 'string',
            calculate: function (data) {
                return data.author ? data.author.sortablename : "";
            }
        },
        'contributor',
        {
            name: 'contributorFullName', 
            type: 'string',
            calculate: function (data) {
                return data.contributor ? data.contributor.sortablename: '';
            }
        },
		{
			name: 'group', type: 'int', 
			calculate: function (data) {
				if (data.author && data.author.login == Ametys.getAppParameter('user').login && data.author.populationId == Ametys.getAppParameter('user').population)
				{
					return 0; // Personal cart
				}
				else
				{
					return 1; // Shared cart
				}
			}
		},
		{name: 'canRead', type: 'boolean', defaultValue: false},
        {name: 'canWrite', type: 'boolean', defaultValue: false},
        {name: 'canAssignRights', type: 'boolean', defaultValue: false}
	]
});
