/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

declare namespace Cart {
    /**
     * Gets the contents from a cart.
     * @param cartId The cart identifier
     * @returns The contents of the cart
     */
    export function getContents(cartId: string): org.ametys.plugins.repository.AmetysObjectIterable;

    /**
     * Gets the queries from a cart.
     * @param cartId The cart identifier
     * @returns The queries of the cart
     */
    export function getQueries(cartId: string): java.util.List;

    /**
     * Gets the resources from a cart.
     * @param cartId The cart identifier
     * @returns The resources of the cart
     */
    export function getResources(cartId: string): org.ametys.plugins.repository.AmetysObjectIterable;

    /**
     * Executes a query from a cart.
     * @param cartId The cart identifier
     * @param queryId The query identifier
     * @returns The AmetysObjects that matches the query
     * @throws Error if cart or query is not found, or if query type is forbidden/unknown
     */
    export function query(cartId: string, queryId: string): org.ametys.plugins.repository.AmetysObjectIterable;
}