<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2013 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

	<xsl:template match="cart">
        <csv>
    		<xsl:call-template name="header"/>
    		
    		<xsl:apply-templates select="cartElement">
    			<xsl:sort select="type"/>
    			<xsl:sort select="group"/>
    			<xsl:sort select="title"/>
    		</xsl:apply-templates>
        
        </csv>
	</xsl:template>
	
	<xsl:template name="header">
        <row>
            <cell><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_TYPE"/></cell>
            <cell><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_TITLE"/></cell>
            <cell><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_DESCRIPTION"/></cell>
            <cell><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_DOCUMENTATION"/></cell>
            <cell><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_CREATOR"/></cell>
            <cell><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_CREATION"/></cell>
            <cell><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_LASTCONTRIBUTOR"/></cell>
            <cell><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_LASTMODIFICATION"/></cell>
            <cell><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_QUERY_TYPE"/></cell>
        </row>
	</xsl:template>
	
	<xsl:template match="cartElement">
        <row>
            <cell><xsl:value-of select="group"/></cell>
            <cell><xsl:value-of select="title"/></cell>
            <cell><xsl:value-of select="description"/></cell>
            <cell><xsl:value-of select="documentation"/></cell>
            <cell><xsl:value-of select="creator"/></cell>
            <cell><i18n:date pattern="long" src-pattern="yyyy-MM-dd'T'HH:mm" value="{creation}"/></cell>
            <cell><xsl:value-of select="lastContributor"/></cell>
            <cell><i18n:date pattern="long" src-pattern="yyyy-MM-dd'T'HH:mm" value="{lastModification}"/></cell>
            <cell><xsl:value-of select="queryType"/></cell>
        </row>
	</xsl:template>
	
</xsl:stylesheet>
