<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2013 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
						      xmlns:xalan="http://xml.apache.org"
							  xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

	<xsl:param name="contextPath"/>
	
	<xsl:template match="cart">
		<html>
	  		<head>
	  			<title><xsl:value-of select="label"/></title>
	  			<link rel="stylesheet" type="text/css" href="{$contextPath}/plugins/cart/resources/css/print.css"/>
	  		</head>
	  		<body onload="window.print()">
                <xsl:for-each select="cartElement[not(group = preceding-sibling::cartElement/group)]">
                    <xsl:sort select="group"/>
                    
                    <xsl:variable name="group" select="group"/>
                    
                    <xsl:choose>
                        <xsl:when test="type = 'content'">
                             <h1><xsl:value-of select="group"/></h1>
                             
                             <xsl:call-template name="table">
                                <xsl:with-param name="elements" select="../cartElement[group = $group]"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="type = 'resource'">
                            <h1><xsl:value-of select="group"/></h1>
                            
                            <xsl:call-template name="table">
                                <xsl:with-param name="elements" select="../cartElement[group = $group]"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="type = 'cartQuery'">
                             <h1><xsl:value-of select="group"/></h1>
                             
                             <xsl:call-template name="table">
                                <xsl:with-param name="elements" select="../cartElement[type = 'cartQuery']"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:when test="type = 'cartQueryFromDirectory'">
                             <h1><xsl:value-of select="group"/></h1>
                             
                             <xsl:call-template name="table">
                                <xsl:with-param name="elements" select="../cartElement[type = 'cartQueryFromDirectory']"/>
                            </xsl:call-template>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
	  		</body>
	 </html>
	</xsl:template>
	
	<xsl:template name="table">
		<xsl:param name="elements"/>
		
		<table>
			<tbody>
				<xsl:call-template name="table-head"/>
				<xsl:for-each select="$elements">
					<xsl:sort select="title"/>
					
					<xsl:call-template name="table-row"/>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	
	<xsl:template name="table-head">
		<tr>
	 		<th style="width:20%"><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_TITLE"/></th>
            <th style="width:15%"><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_DESCRIPTION"/></th>
            <th style="width:15%"><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_DOCUMENTATION"/></th>
            <th style="width:10%"><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_CREATOR"/></th>
            <th style="width:10%"><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_CREATION"/></th>
	 		<th style="width:10%"><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_LASTCONTRIBUTOR"/></th>
	 		<th style="width:10%"><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_LASTMODIFICATION"/></th>
	 		<th style="width:5%"><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_WORKFLOWSTEP"/></th>
            <th style="width:5%"><i18n:text i18n:key="PLUGINS_CART_UITOOL_CART_COLUMN_QUERY_TYPE"/></th>
		</tr>
	</xsl:template>
	
	<xsl:template name="table-row">
		<tr>
			<xsl:if test="(position() mod 2) = 0"><xsl:attribute name="class">even</xsl:attribute></xsl:if>
			<td style="width:20%"><xsl:value-of select="title|@title"/></td>
            <td style="width:15%"><xsl:value-of select="description"/></td>
            <td style="width:15%"><xsl:value-of select="documentation"/></td>
            <td style="width:10%"><xsl:value-of select="creator|metadata/creator"/></td>     
            <td style="width:10%"><i18n:date pattern="long" src-pattern="yyyy-MM-dd'T'HH:mm" value="{creation|metadata/creationDate}"/></td>
		   	<td style="width:10%"><xsl:value-of select="lastContributor|metadata/contributor"/></td>     
		   	<td style="width:10%"><i18n:date pattern="long" src-pattern="yyyy-MM-dd'T'HH:mm" value="{lastModification|metadata/lastModified}"/></td>
		   	<td style="width:5%"><xsl:value-of select="workflow-step"/></td>
            <td style="width:5%"><xsl:value-of select="queryType"/></td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
