<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2013 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="cart">
		
		<panier nom="{label}">
		
			<!-- Objects by type -->
			<xsl:for-each select="cartElement[type = 'content' and not(group = preceding-sibling::cartElement/group)]">
				<xsl:variable name="group" select="group"/>
				
				<objets type="{$group}">
				
					<xsl:for-each select="../cartElement[group = $group]">
						<xsl:sort select="title"/>
						
						<xsl:call-template name="content"/>
					</xsl:for-each>
						
				</objets>
			</xsl:for-each>
			
			<!-- Documents -->
			<xsl:if test="cartElement[type = 'resource']">
				<documents>
					<xsl:apply-templates select="cartElement[type = 'resource']">
						<xsl:sort select="title"/>
					</xsl:apply-templates>
				</documents>
			</xsl:if>
			
			<!-- Cart Queries -->
			<xsl:if test="cartElement[type = 'cartQuery']">
				<recherches>
					<xsl:apply-templates select="cartElement[type = 'cartQuery']">
						<xsl:sort select="title"/>
					</xsl:apply-templates>
				</recherches>
			</xsl:if>
            
            <!-- Queries From Directory -->
            <xsl:if test="cartElement[type = 'cartQueryFromDirectory']">
                <recherches-enregistrees>
                    <xsl:apply-templates select="cartElement[type = 'cartQueryFromDirectory']">
                        <xsl:sort select="title"/>
                    </xsl:apply-templates>
                </recherches-enregistrees>
            </xsl:if>
		</panier>
		
	</xsl:template>
	
	
	<xsl:template name="content">
		<objet id="{@id}">
			<title><xsl:value-of select="title"/></title>
            <creation><xsl:value-of select="creation"/></creation>
            <creator><xsl:value-of select="creator"/></creator>
			<derniereModification><xsl:value-of select="lastModification"/></derniereModification>
			<dernierContributeur><xsl:value-of select="lastContributor"/></dernierContributeur>
			<etat><xsl:value-of select="workflow-step"/></etat>
		</objet>
	</xsl:template>
	
	<xsl:template match="cartElement[type = 'resource']">
		<document id="{@id}">
			<nom><xsl:value-of select="title"/></nom>
            <creation><xsl:value-of select="creation"/></creation>
            <creator><xsl:value-of select="creator"/></creator>
			<derniereModification><xsl:value-of select="lastModification"/></derniereModification>
			<dernierContributeur><xsl:value-of select="lastContributor"/></dernierContributeur>
		</document>
	</xsl:template>
	
	<xsl:template match="cartElement[type = 'cartQuery']">
		<recherche>
			<nom><xsl:value-of select="title"/></nom>
			<description><xsl:value-of select="description"/></description>
            <creation><xsl:value-of select="creation"/></creation>
            <creator><xsl:value-of select="creator"/></creator>
			<derniereModification><xsl:value-of select="lastModification"/></derniereModification>
			<dernierContributeur><xsl:value-of select="lastContributor"/></dernierContributeur>
		</recherche>
	</xsl:template>
    
    <xsl:template match="cartElement[type = 'cartQueryFromDirectory']">
        <recherche id="{@id}">
            <nom><xsl:value-of select="title"/></nom>
            <description><xsl:value-of select="description"/></description>
            <documentation><xsl:value-of select="documentation"/></documentation>
            <creation><xsl:value-of select="creation"/></creation>
            <creator><xsl:value-of select="creator"/></creator>
            <derniereModification><xsl:value-of select="lastModification"/></derniereModification>
            <dernierContributeur><xsl:value-of select="lastContributor"/></dernierContributeur>
            <type><xsl:value-of select="queryType"/></type>
        </recherche>
    </xsl:template>

</xsl:stylesheet>
