/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.cart;

import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;

/**
 * Helper for {@link Cart}
 *
 */
public final class CartHelper
{
    private static final String __PLUGIN_NODE_NAME = "cart";
    
    private CartHelper()
    {
        // Private
    }
    
    /**
     * Get the root plugin storage object.
     * @param resolver The Ametys object resolver
     * @return the root plugin storage object.
     * @throws AmetysRepositoryException if a repository error occurs.
     */
    public static ModifiableTraversableAmetysObject getCartsNode(AmetysObjectResolver resolver) throws AmetysRepositoryException
    {
        try
        {
            ModifiableTraversableAmetysObject pluginsNode = resolver.resolveByPath("/ametys:plugins");
            
            ModifiableTraversableAmetysObject pluginNode = getOrCreateNode(pluginsNode, __PLUGIN_NODE_NAME, "ametys:unstructured");
            
            return getOrCreateNode(pluginNode, "ametys:carts", CartContainerFactory.CARTS_NODETYPE);
        }
        catch (AmetysRepositoryException e)
        {
            throw new AmetysRepositoryException("Unable to get the cart root node", e);
        }
    }
    
    private static ModifiableTraversableAmetysObject getOrCreateNode(ModifiableTraversableAmetysObject parentNode, String nodeName, String nodeType) throws AmetysRepositoryException
    {
        ModifiableTraversableAmetysObject definitionsNode;
        if (parentNode.hasChild(nodeName))
        {
            definitionsNode = parentNode.getChild(nodeName);
        }
        else
        {
            definitionsNode = parentNode.createChild(nodeName, nodeType);
            parentNode.saveChanges();
        }
        return definitionsNode;
    }
    
}
