/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.cart;

import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.right.ProfileAssignmentsToolClientSideElement;

/**
 * {@link ClientSideElement} for the tool displaying the profile assignments for carts
 */
public class CartProfileAssignmentsToolClientSideElement extends ProfileAssignmentsToolClientSideElement
{

    /** The carts DAO */
    private CartsDAO _cartsDAO;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _cartsDAO = (CartsDAO) smanager.lookup(CartsDAO.ROLE);
    }

    @Override
    protected boolean hasRight(Map<String, String> rights, Object context)
    {
        if (context instanceof Cart)
        {
            return _cartsDAO.canAssignRights(_currentUserProvider.getUser(), (Cart) context);
        }
        
        return false;
    }
    
    @Override
    @Callable (rights = {"Plugin_Cart_Rights_Access"})
    public List<Map<String, Object>> getUserGroups(String login, String populationId)
    {
        return super.getUserGroups(login, populationId);
    }
}
