/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.cart.statistics;

import java.util.List;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugins.admin.statistics.Statistics;
import org.ametys.runtime.plugins.admin.statistics.StatisticsNode;
import org.ametys.runtime.plugins.admin.statistics.StatisticsProvider;
import org.ametys.runtime.plugins.admin.statistics.StatisticsValue;

/**
 * Stats about carts
 */
public class CartsStatisticsProvider implements StatisticsProvider, Serviceable, PluginAware
{
    
    /** The Ametys object resolver */
    protected AmetysObjectResolver _resolver;

    private String _id;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
    }
    
    public void setPluginInfo(String pluginName, String featureName, String id)
    {
        _id = id;
    }
    
    public Statistics getStatistics()
    {
        String xpathQuery = "//element(*, ametys:cart)";
        long nbCarts = _resolver.query(xpathQuery).getSize();

        return new StatisticsNode(
            _id,
            new I18nizableText("plugin.cart", "PLUGINS_CART_STATISTICS_CART_LABEL"),
            "ametysicon-basket",
            null,
            List.of(
                new StatisticsValue(
                    "count",
                    new I18nizableText("plugin.cart", "PLUGINS_CART_STATISTICS_CART_CARTS_LABEL"),
                    "ametysicon-maths-number-zero-one",
                    nbCarts
                )
            ),
            true
        );
    }
}
