<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              exclude-result-prefixes="docbook"
                              extension-element-prefixes="text resolver">

	<xsl:import href="ads.xsl"/>
	
    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-css-class-name">ads view-abstract</xsl:variable>     
    
    <xsl:template name="common-content-body-content">
        
        <!-- Category -->
        <xsl:call-template name="ads-category" />
        
        <!-- Location -->
        <xsl:call-template name="ads-location" />
        
        <!-- Image -->
        <xsl:call-template name="ads-first-photo"/>
        
        <!-- Abstract -->
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">content-abstract</xsl:with-param>
            <xsl:with-param name="text" select="metadata/abstract" />
            <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
            <xsl:with-param name="maxDefaultTextSize" select="200" />
        </xsl:call-template>   
        
        <!-- Read more -->
        <xsl:call-template name="common-content-body-readmore"/>
        
        <!-- Price -->
        <xsl:call-template name="ads-price" />
        
        <div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
    </xsl:template>  
    
    <xsl:template name="ads-category">
        <xsl:if test="metadata/category/@id">
            <div class="ads-category">
                <xsl:value-of select="metadata/category/@title"/>
            </div>
        </xsl:if>
    </xsl:template>   
    
    <xsl:template name="ads-location">
        <xsl:if test="metadata/location != ''">
            <div class="ads-location">
                <xsl:value-of select="metadata/location"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="ads-price">
        <xsl:if test="metadata/price != '' and metadata/price != 0">
            <div class="ads-price">
                <xsl:value-of select="metadata/price"/><xsl:text> </xsl:text><i18n:text i18n:key="PLUGINS_CLASSIFIED_ADS_CONTENT_ADS_PRICE_EUROS_UNIT"/>
            </div>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
