<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              exclude-result-prefixes="ametys docbook resolver">

    <xsl:import href="ads.xsl"/>
    
    <xsl:variable name="common-content-css-class-name">ads view-main</xsl:variable>    
    
    <xsl:template name="common-content-body-content">
        <!-- Info -->
        <xsl:call-template name="ads-info" />
 
        <!-- Rich content -->
        <xsl:call-template name="common-content-body-content-rich"/>
        
        <!-- Images -->
        <xsl:call-template name="ads-photos" />
        
        <!-- Contact, Publish date... -->
        <xsl:call-template name="common-content-body-meta"/>  
        
    </xsl:template> 
    
    <xsl:template name="ads-info">
        <ul class="ads-info">
            <li>
                <span class="ads-category"><i18n:text i18n:key="PLUGINS_CLASSIFIED_ADS_CONTENT_ADS_CATEGORY" i18n:catalogue="plugin.classified-ads"/></span> : <xsl:value-of select="metadata/category/@title"/>            
            </li>
            <xsl:if test="metadata/location" >
            <li>
                <span class="ads-location"><i18n:text i18n:key="PLUGINS_CLASSIFIED_ADS_CONTENT_ADS_LOCATION" i18n:catalogue="plugin.classified-ads"/></span> : <xsl:value-of select="metadata/location"/>
            </li>
            </xsl:if>
            <xsl:if test="metadata/phone" >
            <li>
                <span class="ads-phone"><i18n:text i18n:key="PLUGINS_CLASSIFIED_ADS_CONTENT_ADS_PHONE" i18n:catalogue="plugin.classified-ads"/></span> : <xsl:value-of select="metadata/phone"/>
            </li>
            </xsl:if>
            <xsl:if test="metadata/price and metadata/price != 0" >
            <li>
                <span class="ads-price"><i18n:text i18n:key="PLUGINS_CLASSIFIED_ADS_CONTENT_ADS_PRICE" i18n:catalogue="plugin.classified-ads"/></span> : <xsl:value-of select="metadata/price"/><xsl:text> </xsl:text><i18n:text i18n:key="PLUGINS_CLASSIFIED_ADS_CONTENT_ADS_PRICE_EUROS_UNIT"/>
            </li>
            </xsl:if>
        </ul>
    </xsl:template>
    

</xsl:stylesheet>