<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							  xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:ugc="org.ametys.plugins.ugc.transformation.xslt.UgcXSLTHelper"
                              exclude-result-prefixes="docbook resolver ugc">
	
    <xsl:import href="view://stylesheets/content/common.xsl"/>
	
    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-name">ads</xsl:variable>
    
    <!-- +
         | HEAD
         + -->

    <!-- Used in common.xsl -->
    <xsl:template name="common-content-head-title">
        <xsl:call-template name="common-content-head-title-content"/>
    </xsl:template> 

    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-content-body-title">
        <xsl:call-template name="common-content-body-title-content"/>
    </xsl:template> 
    
    <xsl:template name="ads-first-photo">
         <xsl:if test="metadata/illustrations/image1">
            <span class="adds-img">
                <xsl:call-template name="photo">
                        <xsl:with-param name="image" select="metadata/illustrations/image1"/>
                        <xsl:with-param name="rel" select="'single'"/>
                        <xsl:with-param name="class" select="'pirobox'"/>
                        <xsl:with-param name="maxWidth" select="250"/>
                        <xsl:with-param name="maxHeight" select="250"/>
                   </xsl:call-template>
           </span>
         </xsl:if>
    </xsl:template>
    
    <xsl:template name="ads-photos">
        <xsl:if test="metadata/illustrations/*">
        
            <xsl:variable name="class">
                <xsl:text>pirobox</xsl:text>
                <xsl:if test="count(metadata/illustrations/*) &gt; 1"><xsl:text>_gall_</xsl:text><xsl:value-of select="$uniqueId"/></xsl:if>
            </xsl:variable>
            <xsl:variable name="rel">
                <xsl:choose>
                    <xsl:when test="count(metadata/illustrations/*) &gt; 1"><xsl:text>gallery</xsl:text></xsl:when>
                    <xsl:otherwise><xsl:text>single</xsl:text></xsl:otherwise>
                </xsl:choose>        
            </xsl:variable>
        
            <p>
                <xsl:for-each select="metadata/illustrations/*">
                    <span class="adds-img">
                        <xsl:call-template name="photo">
                                <xsl:with-param name="image" select="."/>
                                <xsl:with-param name="rel" select="$rel"/>
                                <xsl:with-param name="class" select="$class"/>
                                <xsl:with-param name="maxWidth" select="250"/>
                                <xsl:with-param name="maxHeight" select="250"/>
                           </xsl:call-template>
                   </span>
                </xsl:for-each>
            </p>
        </xsl:if>
    </xsl:template>         
    
    <xsl:template name="photo">
        <xsl:param name="image" />
        <xsl:param name="rel" />
        <xsl:param name="class" />
        <xsl:param name="maxWidth"/>
        <xsl:param name="maxHeight"/>
        
        <a href="{resolver:resolve($image/@type, $image/@path)}">
            <xsl:attribute name="rel">
                <xsl:value-of select="$rel" />
            </xsl:attribute>
            
            <xsl:attribute name="class">
                <xsl:value-of select="$class" />
            </xsl:attribute>

            <xsl:attribute name="title">
                <xsl:choose>
                    <xsl:when test="alt-text != ''"><xsl:value-of select="alt-text"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="image/@filename"/></xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            
            <xsl:if test="$rendering-context = 'back'">
                <xsl:attribute name="internal">internal</xsl:attribute>
            </xsl:if>
            
            <img src="{resolver:resolveBoundedImage($image/@type, $image/@path, $maxWidth, $maxHeight)}" alt="{alt-text}"/>
        </a>
    </xsl:template>
    
    <xsl:template name="get-page-id">
        <xsl:value-of select="ugc:getUgcPage(//content/@id)"/>
    </xsl:template>
</xsl:stylesheet>
