/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.plugins.contentio.archive.Archivers;
import org.ametys.plugins.contentio.archive.ContentsArchiverHelper;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.PluginArchiver;
import org.ametys.plugins.contentio.archive.SystemViewHandler;
import org.ametys.plugins.contentio.archive.ZipEntryHelper;
import org.ametys.plugins.repository.AmetysObjectFactoryExtensionPoint;
import org.ametys.plugins.repository.collection.AmetysObjectCollection;
import org.ametys.plugins.repository.collection.AmetysObjectCollectionFactory;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.xml.sax.ContentHandler;

public class DefaultPluginArchiver
extends AbstractLogEnabled
implements PluginArchiver,
Serviceable {
    public static final String EXTENSION_ID = "__default";
    private static final String __CONTENT_ROOT_NODE_NAME = "ametys:contents";
    private ContentsArchiverHelper _contentsArchiverHelper;
    private AmetysObjectCollectionFactory _ametysObjectCollectionFactory;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentsArchiverHelper = (ContentsArchiverHelper)((Object)manager.lookup(ContentsArchiverHelper.ROLE));
        AmetysObjectFactoryExtensionPoint ametysObjectFactoryEP = (AmetysObjectFactoryExtensionPoint)manager.lookup(AmetysObjectFactoryExtensionPoint.ROLE);
        this._ametysObjectCollectionFactory = (AmetysObjectCollectionFactory)ametysObjectFactoryEP.getExtension(AmetysObjectCollectionFactory.class.getName());
    }

    @Override
    public void export(String pluginName, Node pluginNode, ZipOutputStream zos, String prefix) throws IOException {
        ZipEntry pluginEntry = new ZipEntry(prefix + "/plugin.xml");
        zos.putNextEntry(pluginEntry);
        try {
            TransformerHandler handler = Archivers.newTransformerHandler();
            handler.setResult(new StreamResult(zos));
            pluginNode.getSession().exportSystemView(pluginNode.getPath(), this.getSystemViewHandler(handler), false, false);
            if (pluginNode.hasNode(__CONTENT_ROOT_NODE_NAME)) {
                this._contentsArchiverHelper.exportContents(prefix + "/contents/", pluginNode.getNode(__CONTENT_ROOT_NODE_NAME), zos);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to archive plugin " + pluginName, e);
        }
    }

    protected ContentHandler getSystemViewHandler(ContentHandler initialHandler) {
        return new SystemViewHandler(initialHandler, name -> __CONTENT_ROOT_NODE_NAME.equals(name), __ -> false);
    }

    @Override
    public ImportReport partialImport(String pluginName, Node allPluginsNode, Path zipPath, String zipPluginEntryPath, Merger merger) throws IOException {
        this._importPluginXml(allPluginsNode, zipPath, zipPluginEntryPath, merger);
        ImportReport importContentReport = this.importContentsIfAny(pluginName, allPluginsNode, zipPath, zipPluginEntryPath, merger);
        return ImportReport.union(importContentReport);
    }

    private void _importPluginXml(Node allPluginsNode, Path zipPath, String zipPluginEntryPath, Merger merger) throws IOException {
        String zipPluginXmlEntryPath = zipPluginEntryPath + "/plugin.xml";
        try (InputStream in = ZipEntryHelper.zipEntryFileInputStream(zipPath, zipPluginXmlEntryPath);){
            Session session = allPluginsNode.getSession();
            String parentAbsPath = allPluginsNode.getPath();
            this.getLogger().info("XML from '{}!{}' will be imported to '{}' with implementation of merger '{}'", new Object[]{zipPath, zipPluginXmlEntryPath, parentAbsPath, merger});
            merger.jcrImportXml(session, parentAbsPath, in);
            session.save();
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    protected ImportReport importContentsIfAny(String pluginName, Node allPluginsNode, Path zipPath, String zipPluginEntryPath, Merger merger) throws IOException {
        String baseImportContentPath = zipPluginEntryPath + "/contents";
        if (ZipEntryHelper.zipEntryFolderExists(zipPath, baseImportContentPath)) {
            try {
                Node pluginNode = allPluginsNode.getNode(pluginName);
                String pluginNodePath = pluginNode.getPath();
                AmetysObjectCollection rootContents = pluginNode.hasNode(__CONTENT_ROOT_NODE_NAME) ? (AmetysObjectCollection)this._ametysObjectCollectionFactory.getObject(pluginNodePath, pluginNode.getNode(__CONTENT_ROOT_NODE_NAME), pluginNodePath) : (AmetysObjectCollection)this._ametysObjectCollectionFactory.createChild(pluginNodePath, pluginNode, __CONTENT_ROOT_NODE_NAME, "ametys:collection");
                return this._contentsArchiverHelper.importContents(baseImportContentPath + "/", rootContents, zipPath, merger, Collections.EMPTY_SET);
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }
        this.getLogger().info("No content to be imported for Plugin '{}', the path '{}!{}' does not exist", new Object[]{pluginName, zipPath, baseImportContentPath});
        return new ImportReport();
    }
}

