/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public final class ImportReport {
    private List<ImportError> _errors;

    public ImportReport() {
        this._errors = new ArrayList<ImportError>();
    }

    private ImportReport(Collection<ImportError> errors) {
        this._errors = new ArrayList<ImportError>(errors);
    }

    public static ImportReport union(Collection<ImportReport> reports) {
        return ImportReport.union((ImportReport[])reports.toArray(ImportReport[]::new));
    }

    public static ImportReport union(ImportReport ... reports) {
        if (reports.length == 0) {
            return new ImportReport();
        }
        if (reports.length == 1) {
            return new ImportReport(reports[0]._errors);
        }
        Collection mergedErrors = Collections.EMPTY_LIST;
        for (ImportReport current : reports) {
            mergedErrors = CollectionUtils.union((Iterable)mergedErrors, current._errors);
        }
        ImportReport merged = new ImportReport(mergedErrors);
        return merged;
    }

    public Collection<ImportError> getErrors() {
        return Collections.unmodifiableCollection(this._errors);
    }

    public void addError(ImportError error) {
        this._errors.add(error);
    }

    public void addFrom(ImportReport other) {
        this._errors.addAll(other._errors);
    }

    public static final class ImportError {
        private final Throwable _throwable;

        public ImportError(Throwable t) {
            this._throwable = t;
        }

        public String getMessage() {
            return this._throwable.getMessage();
        }

        public String getStackTrace() {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(os);
            this._throwable.printStackTrace(printWriter);
            printWriter.flush();
            return ((Object)os).toString();
        }
    }
}

