/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.Mergers;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.StaticEnumerator;

public enum MergePolicy {
    DELETE_BEFORE{

        @Override
        public Merger getMerger() {
            return Mergers.DELETE_BEFORE;
        }
    }
    ,
    IGNORE{

        @Override
        public Merger getMerger() {
            return Mergers.IGNORE;
        }
    }
    ,
    REPLACE{

        @Override
        public Merger getMerger() {
            return Mergers.REPLACE;
        }
    }
    ,
    FAIL{

        @Override
        public Merger getMerger() {
            return Mergers.FAIL;
        }
    };

    static Map<String, MergePolicy> _ids;
    private String _id;
    private I18nizableText _label;
    private I18nizableText _description;

    private MergePolicy() {
        String catalogue = "plugin.contentio";
        String label = String.format("PLUGINS_CONTENTIO_ARCHIVE_IMPORT_SCHEDULABLE_PARAM_MERGE_POLICY_OPTION_%s", this.name());
        this._label = new I18nizableText("plugin.contentio", label);
        String desc = String.format("PLUGINS_CONTENTIO_ARCHIVE_IMPORT_SCHEDULABLE_PARAM_MERGE_POLICY_OPTION_%s_DESC", this.name());
        this._description = new I18nizableText("plugin.contentio", desc);
        this._setId();
    }

    private void _setId() {
        this._id = this.name().toLowerCase().replace('_', '-');
    }

    public abstract Merger getMerger();

    static MergePolicy forId(String id) {
        return _ids.computeIfAbsent(id, MergePolicy::_throwIllegalId);
    }

    private static MergePolicy _throwIllegalId(String id) {
        throw new IllegalArgumentException(String.format("Wrong MergePolicy id: '%s'", id));
    }

    public String getId() {
        return this._id;
    }

    Map<String, Object> toJson() {
        return Map.of("value", this._id, "label", this._label, "desc", this._description);
    }

    static {
        _ids = new LinkedHashMap<String, MergePolicy>();
        for (MergePolicy mergePolicy : MergePolicy.values()) {
            _ids.put(mergePolicy._id, mergePolicy);
        }
    }

    public static class MergePolicyEnumerator
    extends StaticEnumerator<String> {
        public MergePolicyEnumerator() {
            _ids.forEach((id, mergePolicy) -> this.add(mergePolicy._label, id));
        }
    }
}

