/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.export.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.contentio.export.sql.ExportConfiguration;
import org.ametys.plugins.contentio.export.sql.ExportTableInfo;
import org.ametys.plugins.contentio.export.sql.NormalizeNameComponent;
import org.ametys.plugins.repository.model.CompositeDefinition;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class CreateSqlTableComponent
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = CreateSqlTableComponent.class.getName();
    public static final String DEFAULT_LANGUAGE_CODE_FOR_COMMENTS = "en";
    public static final String MYSQL_CONTENT_EXPORT_ENGINE = "MyISAM";
    public static final String MYSQL_CONTENT_EXPORT_CHARSET = "UTF8MB4";
    public static final String COLUMN_PARENT_TABLE_PREFIX = "PID_";
    private static final Pattern _MYSQL_VERSION_NUMBER_EXTRACT = Pattern.compile("^([0-9]+).*$");
    protected ContentTypeExtensionPoint _contentTypeExtensionPoint;
    protected I18nUtils _i18nTranslator;
    protected NormalizeNameComponent _normalizeNameComponent;
    protected LanguagesManager _languageManager;
    private Connection _connection;
    private String _databaseType;
    private LinkedHashMap<String, ExportTableInfo> _tablesInfos;
    private int _commentTableMaxLength;
    private int _commentColumnMaxLength;
    private String _sqlTablePrefix;
    private String _sqlPrefixConf;
    private Map<String, Map<String, String>> _mapping;
    private Map<String, Map<String, String>> _reservedWords;
    private String _mappingPolicy;
    private ArrayList<String> _mappingTablesQueries;
    private boolean _exportNoMultiValuedTable;
    private int _fkIndice;
    private int _pkIndice;

    public void service(ServiceManager manager) throws ServiceException {
        this._i18nTranslator = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._normalizeNameComponent = (NormalizeNameComponent)((Object)manager.lookup(NormalizeNameComponent.ROLE));
        this._languageManager = (LanguagesManager)manager.lookup(LanguagesManager.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, ExportTableInfo> createTables(ExportConfiguration exportConfiguration) throws SQLException, IOException {
        this._sqlPrefixConf = exportConfiguration.getTablePrefix();
        this._sqlTablePrefix = exportConfiguration.getTablePrefix();
        this._mapping = exportConfiguration.getMappingSql();
        this._mappingPolicy = exportConfiguration.getMappingPolicy();
        this._reservedWords = exportConfiguration.getReservedWords();
        this._exportNoMultiValuedTable = exportConfiguration.exportNoMultiValuedTable();
        this._fkIndice = 1;
        this._pkIndice = 1;
        this._tablesInfos = new LinkedHashMap();
        this._mappingTablesQueries = new ArrayList();
        try {
            String datasourceId = (String)Config.getInstance().getValue("org.ametys.plugins.contentio.content.export.datasource");
            this._connection = ConnectionHelper.getConnection((String)datasourceId);
            this._databaseType = ConnectionHelper.getDatabaseType((Connection)this._connection);
            String productVersion = this._connection.getMetaData().getDatabaseProductVersion();
            this.initialize(productVersion);
            boolean isInfoEnabled = this.getLogger().isInfoEnabled();
            if (isInfoEnabled) {
                this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_ANALYZE_TABLE_CREATE_BEGIN")));
            }
            this.createTablesInfos(exportConfiguration.getContentTypesToExport());
            if (isInfoEnabled) {
                this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_ANALYZE_TABLE_CREATE_END")));
                this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_ANALYZE_TABLE_CREATE_MAPPING_BEGIN")));
            }
            this.createMappingTables();
            if (isInfoEnabled) {
                this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_ANALYZE_TABLE_CREATE_MAPPING_END")));
            }
            this.createRichTextDataTable();
            this.createContentTable();
            this.executeQueries();
        }
        finally {
            ConnectionHelper.cleanup((Connection)this._connection);
        }
        return this._tablesInfos;
    }

    protected void initialize(String productVersion) {
        if (this._databaseType.equals("mysql")) {
            Matcher matcher;
            String[] parts = productVersion.split("\\.");
            int majorVersion = Integer.parseInt(parts[0]);
            int minorVersion = 0;
            int patchVersion = 0;
            if (parts.length > 1 && (matcher = _MYSQL_VERSION_NUMBER_EXTRACT.matcher(parts[1])).matches()) {
                minorVersion = Integer.parseInt(matcher.group(1));
            }
            if (parts.length > 2 && (matcher = _MYSQL_VERSION_NUMBER_EXTRACT.matcher(parts[2])).matches()) {
                patchVersion = Integer.parseInt(matcher.group(1));
            }
            if (majorVersion > 5 || majorVersion >= 5 && minorVersion > 5 || majorVersion >= 5 && minorVersion >= 5 && patchVersion >= 3) {
                this._commentTableMaxLength = 2048;
                this._commentColumnMaxLength = 1024;
            } else {
                this._commentTableMaxLength = 60;
                this._commentColumnMaxLength = 255;
            }
        } else {
            this._commentTableMaxLength = 2048;
            this._commentColumnMaxLength = 1024;
        }
    }

    protected void createTablesInfos(Map<String, String> contents) throws SQLException {
        for (Map.Entry<String, String> entry : contents.entrySet()) {
            String contentTypeId = entry.getKey();
            ContentType contentType = (ContentType)this._contentTypeExtensionPoint.getExtension(contentTypeId);
            if (!contentType.isAbstract()) {
                String tableName = entry.getValue();
                String comment = this._i18nTranslator.translate((I18nizable)contentType.getLabel(), DEFAULT_LANGUAGE_CODE_FOR_COMMENTS) + ": " + this._i18nTranslator.translate((I18nizable)contentType.getDescription(), DEFAULT_LANGUAGE_CODE_FOR_COMMENTS);
                this.createQueriesForTableCreation((ModelItemContainer)contentType, tableName, null, comment, false);
            }
            this._sqlTablePrefix = this._sqlPrefixConf;
        }
    }

    protected void createQueriesForTableCreation(ModelItemContainer modelItemContainer, String tableName, String tableParentName, String comment, boolean isSortTable) {
        ExportTableInfo tableInfo = new ExportTableInfo(tableName);
        tableInfo.incrementNbColumns();
        String tableNameNormalized = this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, tableName, this._connection);
        this._tablesInfos.put(tableName, tableInfo);
        StringBuilder currentCreateTableSQLQuery = new StringBuilder();
        currentCreateTableSQLQuery.append("CREATE TABLE ");
        currentCreateTableSQLQuery.append(tableNameNormalized);
        currentCreateTableSQLQuery.append(" (");
        currentCreateTableSQLQuery.append(this._normalizeNameComponent.normalizedColumnName(this._mappingPolicy, "id_" + tableName, tableName, this._reservedWords, this._connection));
        currentCreateTableSQLQuery.append(" VARCHAR(250)");
        currentCreateTableSQLQuery.append(this.createPrimaryKeyQuery());
        currentCreateTableSQLQuery.append(this.createCommentQuery(tableName, "id_" + tableName, "Ametys ID"));
        if (StringUtils.isNotEmpty((CharSequence)tableParentName)) {
            currentCreateTableSQLQuery.append(", ");
            this.addColumnParentId(currentCreateTableSQLQuery, tableParentName, tableName);
        }
        if (isSortTable) {
            currentCreateTableSQLQuery.append(", ");
            this.addSortColumn(currentCreateTableSQLQuery, tableName);
        }
        this.addColumnForContainer(modelItemContainer, currentCreateTableSQLQuery, tableName, "");
        if (modelItemContainer instanceof ContentType) {
            this.addAdditionalData((ContentType)modelItemContainer, currentCreateTableSQLQuery, tableName);
        }
        currentCreateTableSQLQuery.append(") ");
        currentCreateTableSQLQuery.append(this.createEngineQuery());
        currentCreateTableSQLQuery.append(this.createCommentQuery(tableName, null, comment));
        tableInfo.addCreateQuery(currentCreateTableSQLQuery.toString());
    }

    protected void createRichTextDataTable() {
        String dataTableName = this._sqlTablePrefix + "Ametys_RichTextImages";
        ExportTableInfo tableInfo = new ExportTableInfo(dataTableName);
        tableInfo.incrementNbColumns(8);
        String dateTableNameNormalized = this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, "FULL", dataTableName, this._connection);
        this._tablesInfos.put(dataTableName, tableInfo);
        StringBuilder currentCreateTableSQLQuery = new StringBuilder();
        currentCreateTableSQLQuery.append("CREATE TABLE ");
        currentCreateTableSQLQuery.append(dateTableNameNormalized);
        currentCreateTableSQLQuery.append(" (id_data VARCHAR(250)");
        currentCreateTableSQLQuery.append(this.createPrimaryKeyQuery());
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, "id_data", "Data ID"));
        currentCreateTableSQLQuery.append(", id_content VARCHAR(255)");
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, "id_content", "Parent ID"));
        currentCreateTableSQLQuery.append(", attribute_name ");
        currentCreateTableSQLQuery.append(this.convertTypeToSql("string"));
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, "attribute_name", "Richtext attribute name"));
        currentCreateTableSQLQuery.append(", data_name ");
        currentCreateTableSQLQuery.append(this.convertTypeToSql("string"));
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, "data_name", "Name"));
        currentCreateTableSQLQuery.append(", data ");
        currentCreateTableSQLQuery.append(this.convertTypeToSql("file"));
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, "data", "Data"));
        currentCreateTableSQLQuery.append(", data_mimetype VARCHAR(255)");
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, "data_mimetype", "Mime type"));
        currentCreateTableSQLQuery.append(", data_size INT");
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, "data_size", "Size"));
        currentCreateTableSQLQuery.append(", data_lastmodified ");
        currentCreateTableSQLQuery.append(this.convertTypeToSql("datetime"));
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, "data_lastmodified", "Last modification date"));
        currentCreateTableSQLQuery.append(", ");
        this.addSortColumn(currentCreateTableSQLQuery, dataTableName);
        currentCreateTableSQLQuery.append(") ");
        currentCreateTableSQLQuery.append(this.createEngineQuery());
        String comment = "Data table of all rich text";
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, null, comment));
        tableInfo.addCreateQuery(currentCreateTableSQLQuery.toString());
    }

    protected void createContentTable() {
        String dataTableName = this._sqlPrefixConf + "Ametys_AllContents";
        ExportTableInfo tableInfo = new ExportTableInfo(dataTableName);
        tableInfo.incrementNbColumns(2);
        String dataTableNameNormalized = this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, "FULL", dataTableName, this._connection);
        this._tablesInfos.put(dataTableName, tableInfo);
        StringBuilder currentCreateTableSQLQuery = new StringBuilder();
        currentCreateTableSQLQuery.append("CREATE TABLE ");
        currentCreateTableSQLQuery.append(dataTableNameNormalized);
        currentCreateTableSQLQuery.append(" (id_content VARCHAR(80)");
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, "id_content", "Content ID"));
        currentCreateTableSQLQuery.append(", table_name VARCHAR(170)");
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, "table_name", "Table name"));
        currentCreateTableSQLQuery.append(", CONSTRAINT pk_content PRIMARY KEY (id_content, table_name) ");
        currentCreateTableSQLQuery.append(") ");
        currentCreateTableSQLQuery.append(this.createEngineQuery());
        String comment = "Link table of content with it's own table";
        currentCreateTableSQLQuery.append(this.createCommentQuery(dataTableName, null, comment));
        tableInfo.addCreateQuery(currentCreateTableSQLQuery.toString());
    }

    protected void createTableForEnumerator(ElementDefinition definition, String tableParentName, String tableName, String columnName, StringBuilder currentCreateTableSQLQuery) {
        ExportTableInfo tableInfo = new ExportTableInfo(tableName);
        tableInfo.incrementNbColumns();
        String tableNameNormalized = this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, tableName, this._connection);
        this._tablesInfos.put(tableName, tableInfo);
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        sql.append(tableNameNormalized);
        sql.append(" (key_enum ");
        sql.append(definition.getType().getId().equals("long") ? "INT" : "VARCHAR(250)");
        sql.append(this.createPrimaryKeyQuery());
        sql.append(this.createCommentQuery(tableName, "key_enum_" + definition.getName(), "Enumerator key"));
        this.addColumn(sql, "value_enum_" + definition.getName(), tableName, null, "string");
        sql.append(") ");
        sql.append(this.createEngineQuery());
        sql.append(this.createCommentQuery(tableName, null, "Enumerator table " + definition.getName() + " linked to the table " + tableParentName));
        tableInfo.addCreateQuery(sql.toString());
        this.fillTableForEnumerator(definition, tableName);
    }

    protected void fillTableForEnumerator(ElementDefinition definition, String tableName) {
        try {
            for (Map.Entry entry : definition.getEnumerator().getEntries().entrySet()) {
                String enumValue = this._i18nTranslator.translate((I18nizable)entry.getValue(), DEFAULT_LANGUAGE_CODE_FOR_COMMENTS);
                String enumKey = entry.getKey().toString();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO ");
                sql.append(this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, tableName, this._connection));
                sql.append(" VALUES ('");
                sql.append(this._normalizeNameComponent.escapeValue(enumKey, this._connection));
                sql.append("', '");
                sql.append(this._normalizeNameComponent.escapeValue(enumValue, this._connection));
                sql.append("')");
                this._tablesInfos.get(tableName).addInsertQuery(sql.toString());
            }
        }
        catch (Exception e) {
            this.getLogger().warn(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMappingTables() {
        PreparedStatement stmt = null;
        String mappingTableName = this._sqlTablePrefix + "Ametys_tableMapping";
        String mappingColumnName = this._sqlTablePrefix + "Ametys_columnMapping";
        ExportTableInfo mappingTableInfo = new ExportTableInfo(mappingTableName);
        mappingTableInfo.incrementNbColumns(3);
        ExportTableInfo mappingColumnInfo = new ExportTableInfo(mappingColumnName);
        mappingColumnInfo.incrementNbColumns(3);
        String mappingTableNameNormalized = this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, "FULL", mappingTableName, this._connection);
        String mappingColumnNameNormalized = this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, "FULL", mappingColumnName, this._connection);
        this._tablesInfos.put(mappingTableName, mappingTableInfo);
        this._tablesInfos.put(mappingColumnName, mappingColumnInfo);
        StringBuilder createMappingTableSQLQuery = new StringBuilder();
        createMappingTableSQLQuery.append("CREATE TABLE ");
        createMappingTableSQLQuery.append(mappingTableNameNormalized);
        createMappingTableSQLQuery.append(" (id_table INT");
        createMappingTableSQLQuery.append(this.createPrimaryKeyQuery());
        createMappingTableSQLQuery.append(this.createCommentQuery(mappingTableName, "id_table", "Table name ID"));
        createMappingTableSQLQuery.append(", real_name VARCHAR(512)");
        createMappingTableSQLQuery.append(this.createCommentQuery(mappingTableName, "real_name", "Real name"));
        createMappingTableSQLQuery.append(", modified_name VARCHAR(512)");
        createMappingTableSQLQuery.append(this.createCommentQuery(mappingTableName, "modified_name", "Normalized name"));
        createMappingTableSQLQuery.append(") ");
        createMappingTableSQLQuery.append(this.createEngineQuery());
        String comment = "Mapping table between real name and normalized name.";
        createMappingTableSQLQuery.append(this.createCommentQuery(mappingTableName, null, comment));
        try {
            this._mappingTablesQueries.add(createMappingTableSQLQuery.toString());
            stmt = this._connection.prepareStatement(createMappingTableSQLQuery.toString());
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                this.getLogger().error(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_ANALYZE_TABLE_CREATE_MAPPING_TABLE_ERROR")), (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                throw throwable;
            }
            ConnectionHelper.cleanup((Statement)stmt);
        }
        ConnectionHelper.cleanup((Statement)stmt);
        StringBuilder createMappingColumnSQLQuery = new StringBuilder();
        createMappingColumnSQLQuery.append("CREATE TABLE ");
        createMappingColumnSQLQuery.append(mappingColumnNameNormalized);
        createMappingColumnSQLQuery.append(" (id_table INT");
        createMappingColumnSQLQuery.append(this.createCommentQuery(mappingColumnName, "id_table", "Table name id"));
        createMappingColumnSQLQuery.append(this.createForeignKeyQuery("id_table", this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, mappingTableName, this._connection), "id_table"));
        createMappingColumnSQLQuery.append(", real_name VARCHAR(512)");
        createMappingColumnSQLQuery.append(this.createCommentQuery(mappingColumnName, "real_name", "Real column name"));
        createMappingColumnSQLQuery.append(", modified_name VARCHAR(512)");
        createMappingColumnSQLQuery.append(this.createCommentQuery(mappingColumnName, "modified_name", "Normalized column name"));
        createMappingColumnSQLQuery.append(") ");
        createMappingColumnSQLQuery.append(this.createEngineQuery());
        String commentColum = "Mapping table between real column name and normalized column name.";
        createMappingColumnSQLQuery.append(this.createCommentQuery(mappingColumnName, null, commentColum));
        try {
            this._mappingTablesQueries.add(createMappingColumnSQLQuery.toString());
            stmt = this._connection.prepareStatement(createMappingColumnSQLQuery.toString());
            stmt.execute();
        }
        catch (SQLException e) {
            this.getLogger().error(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_ANALYZE_TABLE_CREATE_MAPPING_COLUMN_ERROR")), (Throwable)e);
        }
        finally {
            ConnectionHelper.cleanup((Statement)stmt);
        }
        this.fillMappingTables(mappingTableName, mappingColumnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillMappingTables(String mappingTableName, String mappingColumnName) {
        HashMap mappingTable = (HashMap)this._normalizeNameComponent.getMappingTableNameFromCache();
        HashMap mappingColumn = (HashMap)this._normalizeNameComponent.getMappingTableColumnNameFromCache();
        PreparedStatement stmtTableName = null;
        PreparedStatement stmtColumnName = null;
        try {
            stmtTableName = this.getInsertPreparedStatementFromTableName(mappingTableName);
            stmtColumnName = this.getInsertPreparedStatementFromTableName(mappingColumnName);
            int i = 0;
            for (Map.Entry entry : mappingTable.entrySet()) {
                String realName = (String)entry.getKey();
                String modifiedName = (String)entry.getValue();
                if (this.getLogger().isDebugEnabled()) {
                    String tableName = this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, mappingTableName, this._connection);
                    this.getLogger().debug("INSERT INTO {} VALUES ('{}', '{}', '{}')", new Object[]{tableName, i, realName, modifiedName});
                }
                stmtTableName.setInt(1, i);
                stmtTableName.setString(2, realName);
                stmtTableName.setString(3, modifiedName);
                stmtTableName.addBatch();
                if (mappingColumn.containsKey(realName)) {
                    for (Map.Entry entryCol : ((HashMap)mappingColumn.get(realName)).entrySet()) {
                        String realNameCol = (String)entryCol.getKey();
                        String modifiedNameCol = (String)entryCol.getValue();
                        if (this.getLogger().isDebugEnabled()) {
                            String tableName = this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, mappingTableName, this._connection);
                            this.getLogger().debug("INSERT INTO {} VALUES ('{}', '{}', '{}')", new Object[]{tableName, i, realNameCol, modifiedNameCol});
                        }
                        stmtColumnName.setInt(1, i);
                        stmtColumnName.setString(2, realNameCol);
                        stmtColumnName.setString(3, modifiedNameCol);
                        stmtColumnName.addBatch();
                    }
                }
                ++i;
            }
            stmtTableName.executeBatch();
            stmtColumnName.executeBatch();
        }
        catch (SQLException e) {
            try {
                this.getLogger().error(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_ANALYZE_TABLE_FILL_MAPPING_ERROR")), (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup((Statement)stmtTableName);
                ConnectionHelper.cleanup(stmtColumnName);
                throw throwable;
            }
            ConnectionHelper.cleanup((Statement)stmtTableName);
            ConnectionHelper.cleanup((Statement)stmtColumnName);
        }
        ConnectionHelper.cleanup((Statement)stmtTableName);
        ConnectionHelper.cleanup((Statement)stmtColumnName);
    }

    protected void addColumnForContainer(ModelItemContainer modelItemContainer, StringBuilder currentCreateTableSQLQuery, String tableName, String columnNamePrefix) {
        for (ModelItem modelItem : modelItemContainer.getModelItems()) {
            String name = modelItem.getName();
            String columnName = columnNamePrefix + name;
            if (modelItem instanceof ElementDefinition) {
                ElementDefinition definition = (ElementDefinition)modelItem;
                if (definition.isMultiple()) {
                    if (this._exportNoMultiValuedTable) {
                        String comment = this._i18nTranslator.translate((I18nizable)definition.getLabel(), DEFAULT_LANGUAGE_CODE_FOR_COMMENTS) + ": " + this._i18nTranslator.translate((I18nizable)definition.getDescription(), DEFAULT_LANGUAGE_CODE_FOR_COMMENTS);
                        this.addColumn(currentCreateTableSQLQuery, columnName, tableName, comment, "string");
                        continue;
                    }
                    this.createQueryForMultipleAttribute(definition, tableName, tableName + "_" + columnName);
                    continue;
                }
                this.addColumnForSingleAttribute(definition, currentCreateTableSQLQuery, tableName, columnName);
                if (definition.getEnumerator() == null) continue;
                this.createTableForEnumerator(definition, tableName, tableName + "_" + name, columnName, currentCreateTableSQLQuery);
                continue;
            }
            if (modelItem instanceof CompositeDefinition) {
                this.addColumnForContainer((ModelItemContainer)((CompositeDefinition)modelItem), currentCreateTableSQLQuery, tableName, columnName + "_");
                continue;
            }
            if (!(modelItem instanceof RepeaterDefinition)) continue;
            String commentTable = "Repeater " + this._normalizeNameComponent.normalizedColumnName(this._mappingPolicy, columnName, tableName, this._reservedWords, this._connection) + " linked to the table " + this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, tableName, this._connection);
            this.createQueriesForTableCreation((ModelItemContainer)((RepeaterDefinition)modelItem), tableName + "_" + columnName, tableName, commentTable, true);
        }
    }

    protected void addColumnForSingleAttribute(ElementDefinition definition, StringBuilder currentCreateTableSQLQuery, String tableName, String columnName) {
        String comment = this._i18nTranslator.translate((I18nizable)definition.getLabel(), DEFAULT_LANGUAGE_CODE_FOR_COMMENTS) + ": " + this._i18nTranslator.translate((I18nizable)definition.getDescription(), DEFAULT_LANGUAGE_CODE_FOR_COMMENTS);
        String type = definition.getType().getId();
        if (type.equals("user")) {
            this.addColumn(currentCreateTableSQLQuery, columnName + "_login", tableName, "User login", "string");
            this.addColumn(currentCreateTableSQLQuery, columnName + "_population", tableName, "User population", "string");
        } else if (type.equals("geocode")) {
            this.addColumn(currentCreateTableSQLQuery, columnName + "_longitude", tableName, "Longitude of " + columnName, "double");
            this.addColumn(currentCreateTableSQLQuery, columnName + "_latitude", tableName, "Latitude type of " + columnName, "double");
        } else if (type.equals("binary") || type.equals("file")) {
            String actualColumnName = this.addColumn(currentCreateTableSQLQuery, columnName, tableName, comment, "string");
            this.addColumn(currentCreateTableSQLQuery, actualColumnName + "_data", tableName, "Data of " + columnName, "binary");
            this.addColumn(currentCreateTableSQLQuery, actualColumnName + "_mimetype", tableName, "Mime type of " + columnName, "short-string");
            this.addColumn(currentCreateTableSQLQuery, actualColumnName + "_size", tableName, "Size of " + columnName, "long");
            this.addColumn(currentCreateTableSQLQuery, actualColumnName + "_lastmodified", tableName, "Last modification date of " + columnName, "datetime");
        } else if (type.equals("multilingual-string")) {
            for (String lang : this._languageManager.getAvailableLanguages().keySet()) {
                this.addColumn(currentCreateTableSQLQuery, columnName + "_" + lang, tableName, "Value of " + columnName + " for lang " + lang, "string");
            }
        } else {
            this.addColumn(currentCreateTableSQLQuery, columnName, tableName, comment, type);
        }
    }

    protected String addColumn(StringBuilder currentCreateTableSQLQuery, String columnName, String tableName, String comment, String type) {
        String actualColumnName = this._normalizeNameComponent.normalizedColumnName(this._mappingPolicy, columnName, tableName, this._reservedWords, this._connection);
        currentCreateTableSQLQuery.append(", ").append(actualColumnName);
        currentCreateTableSQLQuery.append(" ").append(this.convertTypeToSql(type));
        if (comment != null) {
            currentCreateTableSQLQuery.append(this.createCommentQuery(tableName, columnName, comment));
        }
        ExportTableInfo tableInfo = this._tablesInfos.get(tableName);
        tableInfo.incrementNbColumns();
        return actualColumnName;
    }

    protected void createQueryForMultipleAttribute(ElementDefinition definition, String tableParentName, String tableName) {
        ExportTableInfo tableInfo = new ExportTableInfo(tableName);
        tableInfo.incrementNbColumns();
        String normalizeTableName = this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, tableName, this._connection);
        this._tablesInfos.put(tableName, tableInfo);
        String normalizedColumnName = this._normalizeNameComponent.normalizedColumnName(this._mappingPolicy, COLUMN_PARENT_TABLE_PREFIX + tableParentName, tableName, this._reservedWords, this._connection);
        StringBuilder currentCreateTableSQLQuery = new StringBuilder();
        currentCreateTableSQLQuery.append("CREATE TABLE ");
        currentCreateTableSQLQuery.append(normalizeTableName);
        currentCreateTableSQLQuery.append(" (");
        currentCreateTableSQLQuery.append(normalizedColumnName);
        currentCreateTableSQLQuery.append(" VARCHAR(245)");
        currentCreateTableSQLQuery.append(this.createCommentQuery(tableName, COLUMN_PARENT_TABLE_PREFIX + tableParentName, "Parent ID of the multiple attribute"));
        String fkName = normalizedColumnName;
        String fkTableName = this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, tableParentName, this._connection);
        String fkColumnName = this._normalizeNameComponent.normalizedColumnName(this._mappingPolicy, "id_" + tableParentName, tableParentName, this._reservedWords, this._connection);
        currentCreateTableSQLQuery.append(this.createForeignKeyQuery(fkName, fkTableName, fkColumnName));
        this.addColumnForSingleAttribute(definition, currentCreateTableSQLQuery, tableName, definition.getName());
        currentCreateTableSQLQuery.append(", ");
        this.addSortColumn(currentCreateTableSQLQuery, tableName);
        String primaryKey = "pk_" + this._pkIndice;
        ++this._pkIndice;
        currentCreateTableSQLQuery.append(", CONSTRAINT ");
        currentCreateTableSQLQuery.append(primaryKey);
        currentCreateTableSQLQuery.append(" PRIMARY KEY (");
        currentCreateTableSQLQuery.append(normalizedColumnName);
        currentCreateTableSQLQuery.append(", position)");
        currentCreateTableSQLQuery.append(") ");
        currentCreateTableSQLQuery.append(this.createEngineQuery());
        String comment = "Multiple attribute " + definition.getName() + " linked to the table" + this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, tableParentName, this._connection);
        currentCreateTableSQLQuery.append(this.createCommentQuery(tableName, null, comment));
        tableInfo.addCreateQuery(currentCreateTableSQLQuery.toString());
    }

    protected void addAdditionalData(ContentType contentType, StringBuilder currentCreateTableSQLQuery, String tableName) {
        this.addColumn(currentCreateTableSQLQuery, "content_title", tableName, "Content title", "string");
        this.addColumn(currentCreateTableSQLQuery, "content_type", tableName, "Content type", "string");
        this.addColumn(currentCreateTableSQLQuery, "content_language", tableName, "Content lang", "string");
        this.addColumn(currentCreateTableSQLQuery, "content_creator", tableName, "Content author", "string");
        this.addColumn(currentCreateTableSQLQuery, "content_creationDate", tableName, "Content creation date", "datetime");
        this.addColumn(currentCreateTableSQLQuery, "content_lastContributor", tableName, "Content last contributor", "string");
        this.addColumn(currentCreateTableSQLQuery, "content_lastModificationDate", tableName, "Content last modification date", "datetime");
        this.addColumn(currentCreateTableSQLQuery, "content_lastValidationDate", tableName, "Content last validation date", "datetime");
        this.addColumn(currentCreateTableSQLQuery, "content_lastMajorValidationDate", tableName, "Content last major validation date", "datetime");
    }

    protected void addSortColumn(StringBuilder currentCreateTableSQLQuery, String tableName) {
        currentCreateTableSQLQuery.append("position INT");
        currentCreateTableSQLQuery.append(this.createCommentQuery(tableName, "position", "Order of the row"));
        ExportTableInfo tableInfo = this._tablesInfos.get(tableName);
        tableInfo.incrementNbColumns();
    }

    protected void addColumnParentId(StringBuilder currentCreateTableSQLQuery, String tableParentName, String tableName) {
        currentCreateTableSQLQuery.append(this._normalizeNameComponent.normalizedColumnName(this._mappingPolicy, COLUMN_PARENT_TABLE_PREFIX + tableParentName, tableName, this._reservedWords, this._connection));
        currentCreateTableSQLQuery.append(" VARCHAR(250)");
        currentCreateTableSQLQuery.append(this.createCommentQuery(tableName, COLUMN_PARENT_TABLE_PREFIX + tableParentName, "Parent table ID " + tableParentName));
        String fkName = this._normalizeNameComponent.normalizedColumnName(this._mappingPolicy, COLUMN_PARENT_TABLE_PREFIX + tableParentName, tableName, this._reservedWords, this._connection);
        String fkTableName = this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, tableParentName, this._connection);
        String fkColumnName = this._normalizeNameComponent.normalizedColumnName(this._mappingPolicy, "id_" + tableParentName, tableParentName, this._reservedWords, this._connection);
        currentCreateTableSQLQuery.append(this.createForeignKeyQuery(fkName, fkTableName, fkColumnName));
        ExportTableInfo tableInfo = this._tablesInfos.get(tableName);
        tableInfo.incrementNbColumns();
    }

    protected String createCommentQuery(String table, String column, String comments) {
        String normalizedComment = this._normalizeNameComponent.normalizedComment(comments, StringUtils.isEmpty((CharSequence)column) ? this._commentTableMaxLength : this._commentColumnMaxLength, this._connection);
        Object commentSql = "";
        if (this._databaseType.equals("mysql")) {
            commentSql = " COMMENT '" + normalizedComment + "'";
        } else if (this._databaseType.equals("oracle")) {
            // empty if block
        }
        return commentSql;
    }

    protected String createForeignKeyQuery(String fkName, String tableName, String columnName) {
        StringBuilder foreignKeySQLQuery = new StringBuilder();
        foreignKeySQLQuery.append(", CONSTRAINT fk_");
        foreignKeySQLQuery.append(this._fkIndice);
        ++this._fkIndice;
        foreignKeySQLQuery.append(" FOREIGN KEY (");
        foreignKeySQLQuery.append(fkName);
        foreignKeySQLQuery.append(")");
        foreignKeySQLQuery.append(" REFERENCES ");
        foreignKeySQLQuery.append(tableName);
        foreignKeySQLQuery.append(" (");
        foreignKeySQLQuery.append(columnName);
        foreignKeySQLQuery.append(")");
        return foreignKeySQLQuery.toString();
    }

    protected String createEngineQuery() {
        if (this._databaseType.equals("mysql")) {
            return "ENGINE=MyISAM ROW_FORMAT=COMPRESSED DEFAULT CHARACTER SET UTF8MB4 ";
        }
        if (this._databaseType.equals("oracle")) {
            return "STORAGE (INITIAL 8K NEXT 8K)";
        }
        return "";
    }

    protected String createPrimaryKeyQuery() {
        return " PRIMARY KEY NOT NULL";
    }

    protected String convertTypeToSql(String type) {
        Map<String, String> mapping = null;
        if (this._databaseType.equals("mysql")) {
            mapping = this._mapping.get("mysql");
        } else if (this._databaseType.equals("oracle")) {
            mapping = this._mapping.get("oracle");
        }
        return mapping != null ? mapping.getOrDefault(type, mapping.get("string")) : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQueries() throws SQLException, IOException {
        int nbTotalTable = this._getNbTable();
        boolean isInfoEnabled = this.getLogger().isInfoEnabled();
        if (isInfoEnabled) {
            ArrayList<String> i18nParams = new ArrayList<String>();
            i18nParams.add(String.valueOf(nbTotalTable));
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_ANALYZE_TABLE_CREATE_BEGINNING", i18nParams)));
        }
        int nbTableCreated = 0;
        int limitPourcentReport = 10;
        try {
            for (Map.Entry<String, ExportTableInfo> entry : this._tablesInfos.entrySet()) {
                ExportTableInfo tableInfo = entry.getValue();
                List<String> queries = tableInfo.getCreateQueries();
                this._executeQueries(queries);
                int pourcent = (nbTableCreated += queries.size()) * 100 / nbTotalTable;
                if (pourcent >= limitPourcentReport) {
                    if (isInfoEnabled) {
                        ArrayList<String> i18nParams = new ArrayList<String>();
                        i18nParams.add(String.valueOf(limitPourcentReport));
                        this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_ANALYZE_TABLE_CREATE_ADVANCE", i18nParams)));
                    }
                    limitPourcentReport += 10;
                }
                this._executeQueries(tableInfo.getCommentQueries());
                this._executeQueries(tableInfo.getInsertQueries());
            }
        }
        catch (IOException e) {
            this.getLogger().error(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_ANALYZE_TABLE_GET_FILE_ERROR")), (Throwable)e);
        }
        finally {
            if (isInfoEnabled) {
                ArrayList<String> i18nParams = new ArrayList<String>();
                i18nParams.add(String.valueOf(nbTableCreated));
                this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_ANALYZE_TABLE_CREATE_FINISH", i18nParams)));
            }
        }
    }

    private int _getNbTable() {
        int nbTable = 0;
        for (Map.Entry<String, ExportTableInfo> entry : this._tablesInfos.entrySet()) {
            ExportTableInfo tableInfo = entry.getValue();
            List<String> listQuery = tableInfo.getCreateQueries();
            nbTable += listQuery.size();
        }
        return nbTable;
    }

    protected void _executeQueries(List<String> listQuery) throws SQLException, IOException {
        for (String query : listQuery) {
            this.getLogger().debug(query);
            PreparedStatement stmt = null;
            try {
                stmt = this._connection.prepareStatement(query);
                stmt.execute();
            }
            catch (SQLException e) {
                try {
                    throw new SQLException("The SQL query failed : " + query, e);
                }
                catch (Throwable throwable) {
                    ConnectionHelper.cleanup(stmt);
                    throw throwable;
                }
            }
            ConnectionHelper.cleanup((Statement)stmt);
        }
    }

    protected PreparedStatement getInsertPreparedStatementFromTableName(String tableName) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(this._normalizeNameComponent.normalizedTableName(this._sqlTablePrefix, this._mappingPolicy, tableName, this._connection));
        sql.append(" VALUES ( ?");
        ExportTableInfo tableInfo = this._tablesInfos.get(tableName);
        for (int i = 1; i < tableInfo.getNbColumns(); ++i) {
            sql.append(", ?");
        }
        sql.append(")");
        PreparedStatement stmt = this._connection.prepareStatement(sql.toString());
        return stmt;
    }
}

