/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.export.sql;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.File;
import org.ametys.cms.data.Geocode;
import org.ametys.cms.data.NamedResource;
import org.ametys.cms.data.RichText;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.contentio.export.sql.ExportConfiguration;
import org.ametys.plugins.contentio.export.sql.ExportCounter;
import org.ametys.plugins.contentio.export.sql.ExportTableInfo;
import org.ametys.plugins.contentio.export.sql.NormalizeNameComponent;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareComposite;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.metadata.MultilingualString;
import org.ametys.plugins.repository.model.CompositeDefinition;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

public class FillSqlTableComponent
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = FillSqlTableComponent.class.getName();
    private static final String _EXCLUDE_XML_TAGS = "<(.*?)>";
    protected ContentTypeExtensionPoint _contentTypeExtensionPoint;
    protected AmetysObjectResolver _resolver;
    protected NormalizeNameComponent _normalizeNameComponent;
    protected Map<String, String> _contentTypesToExport;
    protected I18nUtils _i18nTranslator;
    protected LanguagesManager _languageManager;
    protected UserManager _userManager;
    private Connection _connection;
    private String _sqlTablePrefix;
    private String _sqlPrefixConf;
    private Map<String, ExportTableInfo> _tablesInfos;
    private String _mappingPolicy;
    private LinkedList<PreparedStatement> _stmtList;
    private boolean _exportOnlyValidatedContent;
    private boolean _exportNoMultiValuedTable;
    private String _separator;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._normalizeNameComponent = (NormalizeNameComponent)((Object)manager.lookup(NormalizeNameComponent.ROLE));
        this._i18nTranslator = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._languageManager = (LanguagesManager)manager.lookup(LanguagesManager.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fillTable(ExportConfiguration exportConfiguration, Map<String, ExportTableInfo> tableInfo) throws SQLException, AmetysRepositoryException, IOException {
        this._sqlTablePrefix = exportConfiguration.getTablePrefix();
        this._sqlPrefixConf = exportConfiguration.getTablePrefix();
        this._mappingPolicy = exportConfiguration.getMappingPolicy();
        this._contentTypesToExport = exportConfiguration.getContentTypesToExport();
        this._exportOnlyValidatedContent = exportConfiguration.exportOnlyValidatedContent();
        this._exportNoMultiValuedTable = exportConfiguration.exportNoMultiValuedTable();
        this._separator = exportConfiguration.getSeparator();
        this._tablesInfos = tableInfo;
        this._stmtList = new LinkedList();
        try {
            String datasourceId = (String)Config.getInstance().getValue("org.ametys.plugins.contentio.content.export.datasource");
            this._connection = ConnectionHelper.getConnection((String)datasourceId);
            this.insertValues();
        }
        finally {
            ConnectionHelper.cleanup((Connection)this._connection);
            this._sqlTablePrefix = null;
            this._sqlPrefixConf = null;
            this._mappingPolicy = null;
            this._contentTypesToExport = null;
            this._separator = null;
            this._stmtList = null;
        }
    }

    private void executeInsert() throws SQLException {
        for (PreparedStatement stmt : this._stmtList) {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Query : {}", (Object)stmt.toString());
                }
                stmt.executeBatch();
            }
            catch (SQLException e) {
                throw new SQLException(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_FILL_ERROR_SQL")), e);
            }
            finally {
                ConnectionHelper.cleanup((Statement)stmt);
            }
        }
        this._stmtList.clear();
    }

    protected void insertValues() throws SQLException, AmetysRepositoryException, IOException {
        boolean isInfoEnabled = this.getLogger().isInfoEnabled();
        int nbTotalTypeContenu = this._contentTypesToExport.entrySet().size();
        if (isInfoEnabled && nbTotalTypeContenu != 0) {
            ArrayList<String> i18nParams = new ArrayList<String>();
            i18nParams.add(String.valueOf(nbTotalTypeContenu));
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_FILL_ANALYZE_BEGIN", i18nParams)));
        }
        int nbTypeContenu = 0;
        int pourcentMax = 10;
        for (Map.Entry<String, String> entry : this._contentTypesToExport.entrySet()) {
            int pourcent;
            String contentTypeId = entry.getKey();
            ContentType contentType = (ContentType)this._contentTypeExtensionPoint.getExtension(contentTypeId);
            if (!contentType.isAbstract()) {
                this._sqlTablePrefix = entry.getValue();
                if (isInfoEnabled) {
                    ArrayList<String> i18nParams = new ArrayList<String>();
                    i18nParams.add(String.valueOf(entry.getValue()));
                    this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_FILL_CONTENT_TYPE", i18nParams)));
                }
                this.fillTableForContentType(contentTypeId);
            }
            if ((pourcent = nbTypeContenu * 100 / nbTotalTypeContenu) >= pourcentMax) {
                if (isInfoEnabled) {
                    ArrayList<String> i18nParams = new ArrayList<String>();
                    i18nParams.add(String.valueOf(pourcentMax));
                    this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_FILL_ANALYZE", i18nParams)));
                }
                pourcentMax += 10;
            }
            ++nbTypeContenu;
            this._sqlTablePrefix = this._sqlPrefixConf;
        }
        if (isInfoEnabled) {
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_FILL_END")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillTableForContentType(String contentTypeId) throws SQLException, AmetysRepositoryException, IOException {
        String tableName = this.getTableName(contentTypeId);
        ContentTypeExpression typeE = new ContentTypeExpression(Expression.Operator.EQ, new String[]{contentTypeId});
        String xpath = ContentQueryHelper.getContentXPathQuery((Expression)typeE);
        AmetysObjectIterable contents = this._resolver.query(xpath);
        ContentType cType = (ContentType)this._contentTypeExtensionPoint.getExtension(contentTypeId);
        boolean isInfoEnabled = this.getLogger().isInfoEnabled();
        int nbTotalContent = (int)contents.getSize();
        if (isInfoEnabled && nbTotalContent != 0) {
            ArrayList<String> i18nParams = new ArrayList<String>();
            i18nParams.add(String.valueOf(nbTotalContent));
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_FILL_NB_CONTENT_MAX", i18nParams)));
        }
        int nbContent = 0;
        int pourcentMax = 10;
        for (Content content : contents) {
            List<String> labels = Arrays.asList(((VersionableAmetysObject)content).getAllLabels());
            boolean exportContent = true;
            if (this._exportOnlyValidatedContent) {
                if (labels.contains("Live")) {
                    ((VersionableAmetysObject)content).switchToLabel("Live");
                } else {
                    exportContent = false;
                }
            }
            if (!exportContent) continue;
            String id = content.getId();
            PreparedStatement stmt = null;
            try {
                stmt = this.getInsertPreparedStatementFromTableName(this._sqlTablePrefix, tableName, this._mappingPolicy);
                stmt.setString(1, id);
                this.getLogger().debug(" with id: {}", (Object)id);
                ExportCounter fillIndex = new ExportCounter(2);
                this.fillValues(fillIndex, (ModelItemContainer)cType, (ModelAwareDataHolder)content.getDataHolder(), tableName, "", id, stmt);
                this.fillAdditionalData(fillIndex, content, stmt);
                stmt.execute();
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                throw throwable;
            }
            ConnectionHelper.cleanup((Statement)stmt);
            this._fillContentTable(id, tableName);
            this.executeInsert();
            int pourcent = nbContent * 100 / nbTotalContent;
            if (pourcent >= pourcentMax) {
                if (isInfoEnabled) {
                    ArrayList<String> i18nParams = new ArrayList<String>();
                    i18nParams.add(String.valueOf(pourcentMax));
                    this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_FILL_NB_CONTENT_FILL", i18nParams)));
                }
                pourcentMax += 10;
            }
            ++nbContent;
        }
        if (isInfoEnabled && nbTotalContent != 0) {
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_FILL_NB_CONTENT_FILL_MAX")));
        }
    }

    private void _fillContentTable(String idContent, String tableName) throws SQLException {
        String dataTableName = this._sqlPrefixConf + "Ametys_AllContents";
        PreparedStatement stmt = this.getInsertPreparedStatementFromTableName(this._sqlPrefixConf, dataTableName, "FULL");
        this._stmtList.add(stmt);
        stmt.setString(1, idContent);
        stmt.setString(2, tableName);
        stmt.addBatch();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(stmt.toString());
        }
    }

    protected void fillValues(ExportCounter fillIndex, ModelItemContainer modelItemContainer, ModelAwareDataHolder dataHolder, String tableName, String columnNamePrefix, String id, PreparedStatement stmt) throws SQLException, AmetysRepositoryException, IOException {
        for (ModelItem modelItem : modelItemContainer.getModelItems()) {
            ModelAwareRepeater repeater;
            String name = modelItem.getName();
            String columnName = columnNamePrefix + name;
            if (modelItem instanceof ElementDefinition) {
                ElementDefinition definition = (ElementDefinition)modelItem;
                if (definition.isMultiple() && !this._exportNoMultiValuedTable) {
                    if (dataHolder == null || !dataHolder.hasValue(name)) continue;
                    this.fillTableForMultipleAttribute(definition, dataHolder, name, tableName + "_" + columnName, id);
                    continue;
                }
                this.fillValue(fillIndex, definition, dataHolder, name, id, stmt);
                continue;
            }
            if (modelItem instanceof CompositeDefinition) {
                ModelAwareComposite composite = dataHolder != null ? (ModelAwareComposite)dataHolder.getValue(name) : null;
                this.fillValues(fillIndex, (ModelItemContainer)((CompositeDefinition)modelItem), (ModelAwareDataHolder)composite, tableName, columnName + "_", id, stmt);
                continue;
            }
            if (!(modelItem instanceof RepeaterDefinition) || dataHolder == null || (repeater = dataHolder.getRepeater(name)) == null) continue;
            this.fillTableForRepeater((RepeaterDefinition)modelItem, dataHolder.getRepeater(name), tableName + "_" + columnName, id);
        }
    }

    protected void fillTableForRepeater(RepeaterDefinition definition, ModelAwareRepeater repeater, String tableName, String id) throws SQLException, AmetysRepositoryException, IOException {
        PreparedStatement stmt = this.getInsertPreparedStatementFromTableName(this._sqlTablePrefix, tableName, this._mappingPolicy);
        this._stmtList.add(stmt);
        for (ModelAwareRepeaterEntry entry : repeater.getEntries()) {
            int position = entry.getPosition();
            String idRepeater = id + "@" + position;
            stmt.setString(1, idRepeater);
            stmt.setString(2, id);
            stmt.setInt(3, position);
            ExportCounter fillIndex = new ExportCounter(4);
            this.fillValues(fillIndex, (ModelItemContainer)definition, (ModelAwareDataHolder)entry, tableName, "", idRepeater, stmt);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(stmt.toString());
            }
            stmt.addBatch();
        }
    }

    protected void fillTableForMultipleAttribute(ElementDefinition definition, ModelAwareDataHolder dataHolder, String name, String tableName, String id) throws SQLException, AmetysRepositoryException, IOException {
        PreparedStatement stmt = this.getInsertPreparedStatementFromTableName(this._sqlTablePrefix, tableName, this._mappingPolicy);
        this._stmtList.add(stmt);
        stmt.setString(1, id);
        ExportCounter fillIndex = new ExportCounter(2);
        this.fillValue(fillIndex, definition, dataHolder, name, id, stmt);
    }

    protected void fillValue(ExportCounter fillIndex, ElementDefinition definition, ModelAwareDataHolder dataHolder, String name, String id, PreparedStatement stmt) throws SQLException, AmetysRepositoryException, IOException {
        Object value;
        String type = definition.getType().getId();
        Object object = value = dataHolder != null ? dataHolder.getValue(name) : null;
        if (definition.isMultiple()) {
            if (this._exportNoMultiValuedTable) {
                Object multipleValue = "";
                if (value != null) {
                    Object[] values = (Object[])value;
                    for (int i = 0; i < values.length; ++i) {
                        if (i != 0) {
                            multipleValue = (String)multipleValue + this._separator;
                        }
                        multipleValue = (String)multipleValue + this._getValueForNoMultiValuedTable(values[i], type);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)multipleValue)) {
                    stmt.setString(fillIndex.getCount(), (String)multipleValue);
                } else {
                    stmt.setNull(fillIndex.getCount(), 12);
                }
                fillIndex.incrementCount();
            } else {
                int position = 1;
                if (value != null) {
                    Object[] values;
                    for (Object o : values = (Object[])value) {
                        int nbPos = this._setValue(o, 2, stmt, type, name, id);
                        stmt.setInt(2 + nbPos, position);
                        ++position;
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug(stmt.toString());
                        }
                        stmt.addBatch();
                    }
                }
            }
        } else if (value != null) {
            int nbPos = this._setValue(value, fillIndex.getCount(), stmt, type, name, id);
            fillIndex.incrementCount(nbPos);
        } else {
            int nbPos = this._setNull(fillIndex.getCount(), stmt, type);
            fillIndex.incrementCount(nbPos);
        }
    }

    private int _setValue(Object value, int position, PreparedStatement stmt, String type, String name, String contentId) throws SQLException, IOException {
        switch (type) {
            case "content": {
                stmt.setString(position, ((ContentValue)value).getContentId());
                return 1;
            }
            case "long": {
                stmt.setLong(position, (Long)value);
                return 1;
            }
            case "boolean": {
                stmt.setBoolean(position, (Boolean)value);
                return 1;
            }
            case "date": {
                stmt.setDate(position, Date.valueOf((LocalDate)value));
                return 1;
            }
            case "datetime": {
                stmt.setTimestamp(position, Timestamp.from(((ZonedDateTime)value).toInstant()));
                return 1;
            }
            case "double": {
                stmt.setDouble(position, (Double)value);
                return 1;
            }
            case "user": {
                UserIdentity user = (UserIdentity)value;
                stmt.setString(position, user.getLogin());
                stmt.setString(position + 1, user.getPopulationId());
                return 2;
            }
            case "geocode": {
                Geocode geocode = (Geocode)value;
                stmt.setDouble(position, geocode.getLongitude());
                stmt.setDouble(position + 1, geocode.getLatitude());
                return 2;
            }
            case "multilingual-string": {
                MultilingualString multilingualString = (MultilingualString)value;
                int i = 0;
                for (String lang : this._languageManager.getAvailableLanguages().keySet()) {
                    Locale locale = LocaleUtils.toLocale((String)lang);
                    if (multilingualString.hasLocale(locale)) {
                        stmt.setString(position + i, multilingualString.getValue(locale));
                    } else {
                        stmt.setNull(position + i, 12);
                    }
                    ++i;
                }
                return i;
            }
            case "binary": 
            case "file": {
                File file = (File)value;
                stmt.setString(position, file.getName());
                stmt.setBlob(position + 1, (InputStream)((AutoCloseInputStream.Builder)AutoCloseInputStream.builder().setInputStream(file.getInputStream())).get());
                stmt.setString(position + 2, file.getMimeType());
                stmt.setLong(position + 3, file.getLength());
                stmt.setTimestamp(position + 4, Timestamp.from(file.getLastModificationDate().toInstant()));
                return 5;
            }
            case "rich-text": {
                RichText richText = (RichText)value;
                try (InputStream is = richText.getInputStream();){
                    String richTextValue = IOUtils.toString((InputStream)is, (String)"UTF-8").replaceAll(_EXCLUDE_XML_TAGS, "");
                    stmt.setString(position, richTextValue);
                }
                catch (IOException e) {
                    this.getLogger().warn("Error with richText of attribute '{}' of content '{}'.", (Object)name, (Object)contentId);
                    stmt.setNull(position, 2004);
                }
                this.fillColumnForRichTextData(richText, name, contentId);
                return 1;
            }
        }
        stmt.setString(position, value.toString());
        return 1;
    }

    private int _setNull(int position, PreparedStatement stmt, String type) throws SQLException {
        switch (type) {
            case "long": {
                stmt.setNull(position, 4);
                return 1;
            }
            case "boolean": {
                stmt.setNull(position, 0);
                return 1;
            }
            case "date": 
            case "datetime": {
                stmt.setNull(position, 91);
                return 1;
            }
            case "double": {
                stmt.setNull(position, 8);
                return 1;
            }
            case "user": {
                stmt.setNull(position, 12);
                stmt.setNull(position + 1, 12);
                return 2;
            }
            case "geocode": {
                stmt.setNull(position, 8);
                stmt.setNull(position + 1, 8);
                return 2;
            }
            case "multilingual-string": {
                Set availableLanguages = this._languageManager.getAvailableLanguages().keySet();
                for (int i = 0; i < availableLanguages.size(); ++i) {
                    stmt.setNull(position + i, 12);
                }
                return availableLanguages.size();
            }
            case "binary": 
            case "file": {
                stmt.setNull(position, 12);
                stmt.setNull(position + 1, 2004);
                stmt.setNull(position + 2, 12);
                stmt.setNull(position + 3, 4);
                stmt.setNull(position + 4, 91);
                return 5;
            }
            case "rich-text": {
                stmt.setNull(position, 2004);
                return 1;
            }
        }
        stmt.setNull(position, 12);
        return 1;
    }

    private String _getValueForNoMultiValuedTable(Object value, String type) {
        if ("user".equals(type)) {
            User user = this._userManager.getUser((UserIdentity)value);
            if (user != null) {
                return user.getFullName();
            }
            return UserIdentity.userIdentityToString((UserIdentity)((UserIdentity)value));
        }
        return value.toString();
    }

    protected void fillAdditionalData(ExportCounter fillIndex, Content content, PreparedStatement stmt) throws AmetysRepositoryException, SQLException {
        if (content != null) {
            stmt.setString(fillIndex.getCount(), content.getTitle());
            fillIndex.incrementCount();
            stmt.setString(fillIndex.getCount(), content.getTypes()[0]);
            fillIndex.incrementCount();
            stmt.setString(fillIndex.getCount(), content.getLanguage());
            fillIndex.incrementCount();
            stmt.setString(fillIndex.getCount(), content.getCreator().getLogin());
            fillIndex.incrementCount();
            if (content.getCreationDate() != null) {
                Date sqlCreationDate = new Date(content.getCreationDate().toInstant().toEpochMilli());
                stmt.setDate(fillIndex.getCount(), sqlCreationDate);
            } else {
                stmt.setNull(fillIndex.getCount(), 91);
            }
            fillIndex.incrementCount();
            stmt.setString(fillIndex.getCount(), content.getLastContributor().getLogin());
            fillIndex.incrementCount();
            if (content.getLastModified() != null) {
                Date sqlLastModificationDate = new Date(content.getLastModified().toInstant().toEpochMilli());
                stmt.setDate(fillIndex.getCount(), sqlLastModificationDate);
            } else {
                stmt.setNull(fillIndex.getCount(), 91);
            }
            fillIndex.incrementCount();
            if (content.getLastValidationDate() != null) {
                Date sqlLastValidationDate = new Date(content.getLastValidationDate().toInstant().toEpochMilli());
                stmt.setDate(fillIndex.getCount(), sqlLastValidationDate);
            } else {
                stmt.setNull(fillIndex.getCount(), 91);
            }
            fillIndex.incrementCount();
            if (content.getLastMajorValidationDate() != null) {
                Date sqlLastMajorValidationDate = new Date(content.getLastMajorValidationDate().toInstant().toEpochMilli());
                stmt.setDate(fillIndex.getCount(), sqlLastMajorValidationDate);
            } else {
                stmt.setNull(fillIndex.getCount(), 91);
            }
            fillIndex.incrementCount();
        }
    }

    protected void fillColumnForRichTextData(RichText richText, String attributeName, String contentId) throws AmetysRepositoryException, SQLException, IOException {
        String dataTableName = this._sqlPrefixConf + "Ametys_RichTextImages";
        PreparedStatement stmt = this.getInsertPreparedStatementFromTableName(this._sqlPrefixConf, dataTableName, "FULL");
        this._stmtList.add(stmt);
        int position = 1;
        for (NamedResource resource : richText.getAttachments()) {
            String id = contentId + "@" + attributeName + ";" + resource.getFilename();
            stmt.setString(1, id);
            stmt.setString(2, contentId);
            stmt.setString(3, attributeName);
            stmt.setString(4, resource.getFilename());
            stmt.setBlob(5, (InputStream)((AutoCloseInputStream.Builder)AutoCloseInputStream.builder().setInputStream(resource.getInputStream())).get());
            stmt.setString(6, resource.getMimeType());
            stmt.setLong(7, resource.getLength());
            stmt.setTimestamp(8, Timestamp.from(resource.getLastModificationDate().toInstant()));
            stmt.setInt(9, position);
            ++position;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(stmt.toString());
            }
            stmt.addBatch();
        }
    }

    protected PreparedStatement getInsertPreparedStatementFromTableName(String prefix, String tableName, String mappingPolicy) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(this._normalizeNameComponent.normalizedTableName(prefix, mappingPolicy, tableName, this._connection));
        sql.append(" VALUES ( ?");
        ExportTableInfo tableInfo = this._tablesInfos.get(tableName);
        for (int i = 1; i < tableInfo.getNbColumns(); ++i) {
            sql.append(", ?");
        }
        sql.append(")");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: {}", (Object)sql.toString());
        }
        PreparedStatement stmt = this._connection.prepareStatement(sql.toString());
        return stmt;
    }

    protected String getTableName(String cTypeId) {
        return this._contentTypesToExport.get(cTypeId);
    }
}

