/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.in;

import jakarta.mail.MessagingException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.util.HttpUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.contentio.in.ContentImportException;
import org.ametys.plugins.contentio.in.ContentImportManager;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.RejectedPart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class ImportFileAction
extends ServiceableAction {
    protected ContentImportManager _importManager;
    protected SourceResolver _sourceResolver;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._importManager = (ContentImportManager)((Object)serviceManager.lookup(ContentImportManager.ROLE));
        this._sourceResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
    }

    public Map act(Redirector redirector, org.apache.cocoon.environment.SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        boolean sendMail = parameters.getParameterAsBoolean("send-mail", false);
        boolean success = false;
        HashMap<String, String> result = new HashMap<String, String>();
        ContentImportManager.ImportResult importResult = null;
        Part part = (Part)request.get("file");
        if (part instanceof RejectedPart || part == null) {
            result.put("error", "rejected");
        } else {
            PartOnDisk uploadedFilePart = (PartOnDisk)part;
            File uploadedFile = uploadedFilePart.getFile();
            try {
                importResult = this._importManager.importContents(uploadedFile);
                if (!importResult.isImporterFound()) {
                    result.put("error", "no-importer");
                } else {
                    Set<String> contentIds = importResult.getImportedContentIds();
                    success = true;
                    result.put("importedCount", Integer.toString(contentIds.size()));
                    result.put("importedIds", StringUtils.join(contentIds, (char)'|'));
                }
            }
            catch (ContentImportException e) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(os));
                this.getLogger().error("Exception importing contents from file: " + uploadedFile.getName(), (Throwable)e);
                result.put("message", os.toString());
            }
        }
        result.put("success", String.valueOf(success));
        if (sendMail) {
            this.sendMail(success, importResult);
        }
        return result;
    }

    protected void sendMail(boolean success, ContentImportManager.ImportResult importResult) {
        try {
            String sysadminMail = (String)Config.getInstance().getValue("smtp.mail.sysadminto");
            String baseUrl = HttpUtils.sanitize((String)((String)Config.getInstance().getValue("cms.url")));
            HashMap<String, Object> mailParams = new HashMap<String, Object>();
            if (success) {
                mailParams.put("success", true);
                mailParams.put("baseUrl", baseUrl);
                mailParams.put("contentIds", importResult.getImportedContentIds());
            } else {
                mailParams.put("success", false);
                if (importResult != null && !importResult.isImporterFound()) {
                    mailParams.put("error", "no-importer");
                }
            }
            Source bodySource = this._sourceResolver.resolveURI("cocoon://_plugins/contentio/mail/body", null, mailParams);
            String body = IOUtils.toString((InputStream)bodySource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            I18nizableText i18nSubject = new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_IMPORTFILE_MAIL_SUBJECT");
            String subject = this._i18nUtils.translate((I18nizable)i18nSubject);
            if (StringUtils.isNotBlank((CharSequence)sysadminMail)) {
                SendMailHelper.newMail().withSubject(subject).withTextBody(body).withRecipient(sysadminMail).sendMail();
            }
        }
        catch (MessagingException | IOException e) {
            this.getLogger().warn("Error sending the import report e-mail.", e);
        }
    }
}

