/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.impl.typehandler;

import com.google.common.base.CharMatcher;
import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLClobTypeHandler
extends BaseTypeHandler<Object> {
    private static Logger __logger = LoggerFactory.getLogger(SQLClobTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        ps.setObject(i, parameter);
    }

    public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Clob clob = rs.getClob(columnName);
        return this._transformClobToString(clob);
    }

    public Object getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Clob clob = rs.getClob(columnIndex);
        return this._transformClobToString(clob);
    }

    public Object getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Clob clob = cs.getClob(columnIndex);
        return this._transformClobToString(clob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _transformClobToString(Clob clob) throws SQLException {
        try {
            String strValue = IOUtils.toString((Reader)clob.getCharacterStream());
            String string = CharMatcher.javaIsoControl().and(CharMatcher.anyOf((CharSequence)"\r\n\t").negate()).removeFrom((CharSequence)strValue);
            return string;
        }
        catch (IOException e) {
            __logger.warn("Can't transform clob to string", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            clob.free();
        }
    }
}

