/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.rights;

import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.right.RightsException;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.core.impl.right.AbstractHierarchicalAccessController;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class SynchronizedContentAccessController
extends AbstractHierarchicalAccessController<Object> {
    private SynchronizableContentsCollectionDAO _collectionsDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._collectionsDAO = (SynchronizableContentsCollectionDAO)((Object)manager.lookup(SynchronizableContentsCollectionDAO.ROLE));
    }

    public boolean supports(Object object) {
        String str;
        Content content;
        String collectionId = null;
        if (object instanceof Content && (content = (Content)object).getInternalDataHolder().hasValue("scc")) {
            collectionId = ((String[])content.getInternalDataHolder().getValue("scc"))[0];
        } else if (object instanceof String && (str = (String)object).startsWith("/synchronized-contents/")) {
            collectionId = StringUtils.substringAfter((String)str, (String)"/synchronized-contents/");
        }
        if (collectionId != null) {
            return this._collectionsDAO.getSynchronizableContentsCollection(collectionId) != null;
        }
        return false;
    }

    protected Set<Object> _getParents(Object object) {
        if (object instanceof Content) {
            String[] collectionIds = (String[])((Content)object).getInternalDataHolder().getValue("scc");
            return Set.of("/synchronized-contents/" + collectionIds[0]);
        }
        return null;
    }

    protected Set<? extends Object> _convertWorkspaceToRootRightContexts(Set<Object> workspacesContexts) {
        try {
            if (workspacesContexts.contains("/cms")) {
                HashSet<CallSite> rootContexts = new HashSet<CallSite>();
                for (SynchronizableContentsCollection synchronizableContentsCollection : this._collectionsDAO.getSynchronizableContentsCollections()) {
                    if (!synchronizableContentsCollection.handleRightAssignmentContext()) continue;
                    rootContexts.add((CallSite)((Object)("/synchronized-contents/" + synchronizableContentsCollection.getId())));
                }
                return rootContexts;
            }
            return null;
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().debug("Root node for synchronized contents does not exist. Could not determine the contents root node to obtain all permissions");
            return null;
        }
    }

    protected I18nizableText getObjectLabelForExplanation(Object object) throws RightsException {
        String str;
        if (object instanceof Content) {
            Map<String, I18nizableText> params = Map.of("title", this.getObjectLabel(object));
            return new I18nizableText("plugin.cms", "PLUGINS_CMS_CONTENT_ACCESS_CONTROLLER_CONTENT_CONTEXT_EXPLANATION_LABEL", params);
        }
        if (object instanceof String && (str = (String)object).startsWith("/synchronized-contents/")) {
            String collectionId = StringUtils.substringAfter((String)str, (String)"/synchronized-contents/");
            SynchronizableContentsCollection collection = this._collectionsDAO.getSynchronizableContentsCollection(collectionId);
            return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_SCC_ACCESS_CONTROLLER_COLLECTION_CONTEXT_EXPLANATION_LABEL", Map.of("collection", collection.getLabel()));
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectLabel(Object object) throws RightsException {
        String str;
        if (object instanceof Content) {
            Content content = (Content)object;
            return new I18nizableText(content.getTitle());
        }
        if (object instanceof String && (str = (String)object).startsWith("/synchronized-contents/")) {
            String collectionId = StringUtils.substringAfter((String)str, (String)"/synchronized-contents/");
            SynchronizableContentsCollection collection = this._collectionsDAO.getSynchronizableContentsCollection(collectionId);
            return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_SCC_ACCESS_CONTROLLER_COLLECTION_CONTEXT_LABEL", Map.of("collection", collection.getLabel()));
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        String str;
        String collectionId = null;
        if (object instanceof Content) {
            Content content = (Content)object;
            collectionId = ((String[])content.getInternalDataHolder().getValue("scc"))[0];
        } else if (object instanceof String && (str = (String)object).startsWith("/synchronized-contents/")) {
            collectionId = StringUtils.substringAfter((String)str, (String)"/synchronized-contents/");
        }
        SynchronizableContentsCollection collection = this._collectionsDAO.getSynchronizableContentsCollection(collectionId);
        Map<String, I18nizableText> params = Map.of("collection", collection != null ? collection.getLabel() : new I18nizableText(collectionId));
        return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_RIGHT_ASSIGNMENT_CONTEXT_SYNCHRONIZED_CONTENTS_LABEL", params);
    }

    public int getObjectPriority(Object object) {
        if (object instanceof String) {
            return 10;
        }
        return super.getObjectPriority(object);
    }
}

