/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Content context for profile assignments.
 * This implementation is for Synchronized contents, because it use the parameter "collection-id" to limit the search and to change to root identifier
 */
Ext.define('Ametys.plugins.contentio.profiles.SynchronizedContentRightAssignmentContext', {
    extend: 'Ametys.plugins.cms.profiles.ContentRightAssignmentContext',

    /**
     * @private
     * @property {String} _sccId The synchronized content collection identifier
     */
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        this._sccId = config['scc'];
    },
    
    _getDefaultSearchValues: function()
    {
        return Ext.apply(this.callParent(arguments), { "values": {"reference-scc-eq": this._sccId}});
    }
});
