<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                exclude-result-prefixes="i18n">

    <xsl:import href="plugin:cms://stylesheets/properties/technical/content/date.xsl"/>

    <xsl:param name="contextPath"/>
    
    <xsl:template match="/ActionResult">
        <xsl:apply-templates select="*"/>
    </xsl:template>
    
    <xsl:template match="*">
        <xsl:if test="* or text() != ''">
            <p>
                <span class="title"><xsl:apply-templates select="." mode="title"/></span>
                <span><xsl:apply-templates select="." mode="value"/></span>
            </p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="scc" mode="title">
        <i18n:text i18n:catalogue="plugin.contentio" i18n:key="PLUGINS_CONTENTIO_SYNCHRONIZABLE_CONTENT_COLLECTIONS"/> 
    </xsl:template>
    
    <xsl:template match="lastSynchronization" mode="title">
        <i18n:text i18n:catalogue="plugin.contentio" i18n:key="PLUGINS_CONTENTIO_SYNCHRONIZE_CONTENT_LAST_SYNCHRONIZATION_LABEL"/> 
    </xsl:template>
    
    <xsl:template match="scc" mode="value">
        <xsl:for-each select="scc">
            <xsl:value-of select="label"/><xsl:text> (</xsl:text><xsl:value-of select="value"/><xsl:text>)</xsl:text>
            <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="lastSynchronization" mode="value">
            <xsl:call-template name="render-date-and-user" />
    </xsl:template>
    
</xsl:stylesheet>
