/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.in;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpRequest;
import org.apache.commons.lang3.StringUtils;

import org.ametys.plugins.contentio.in.ContentImportManager.ImportResult;

/**
 * Import contents from a file transmitted as a POST entity.
 */
public class ImportPostBodyAction extends ImportFileAction
{
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        boolean sendMail = parameters.getParameterAsBoolean("send-mail", false);
        
        boolean success = false;
        
        Map<String, String> result = new HashMap<>();
        
        ImportResult importResult = null;
        
        if (request instanceof HttpRequest)
        {
            InputStream inputStream = ((HttpRequest) request).getInputStream();
            String name = request.getParameter("name");
            
            importResult = _importManager.importContents(inputStream, name);
            
            if (!importResult.isImporterFound())
            {
                result.put("error", "no-importer");
            }
            else
            {
                Set<String> contentIds = importResult.getImportedContentIds();
                success = true;
                
                result.put("importedCount", Integer.toString(contentIds.size()));
                result.put("importedIds", StringUtils.join(contentIds, '|'));
            }
        }
        
        result.put("success", String.valueOf(success));
        
        if (sendMail)
        {
            sendMail(success, importResult);
        }
        
        return result;
    }
    
}
