/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.synchronize;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * Collections enumerator
 */
public class CollectionEnumerator implements Enumerator<String>, Serviceable
{
    private ServiceManager _serviceManager;
    private SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _serviceManager = manager;
    }
    
    public I18nizableText getEntry(String value) throws Exception
    {
        SynchronizableContentsCollection collection = _getSynchronizableContentsCollectionDAO().getSynchronizableContentsCollection(value);
        return collection == null ? new I18nizableText("") : collection.getLabel();
    }

    public Map<String, I18nizableText> getEntries() throws Exception
    {
        Map<String, I18nizableText> entries = new HashMap<>();
        
        for (SynchronizableContentsCollection collection : _getSynchronizableContentsCollectionDAO().getSynchronizableContentsCollections())
        {
            entries.put(collection.getId(), collection.getLabel());
        }
        return entries;
    }
    
    /**
     * Retrieves the synchronizable contents collection DAO
     * @return the synchronizable contents collection DAO
     */
    protected SynchronizableContentsCollectionDAO _getSynchronizableContentsCollectionDAO()
    {
        if (_synchronizableContentsCollectionDAO == null)
        {
            try
            {
                _synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO) _serviceManager.lookup(SynchronizableContentsCollectionDAO.ROLE);
            }
            catch (ServiceException e)
            {
                throw new RuntimeException("Unable to lookup after the synchronizable contents collection DAO", e);
            }
        }
        
        return _synchronizableContentsCollectionDAO;
    }
}
