/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.datafiller;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.forms.dao.FormDAO;
import org.ametys.plugins.forms.dao.FormDirectoryDAO;
import org.ametys.plugins.forms.dao.FormPageDAO;
import org.ametys.plugins.forms.dao.FormQuestionDAO;
import org.ametys.plugins.forms.repository.Form;
import org.ametys.plugins.forms.repository.FormPage;
import org.ametys.plugins.forms.repository.FormQuestion;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class GenericFormCreationManager
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = GenericFormCreationManager.class.getName();
    private FormDAO _formDAO;
    private FormDirectoryDAO _formDirectoryDAO;
    private FormPageDAO _formPageDAO;
    private FormQuestionDAO _formQuestionDAO;
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._formQuestionDAO = (FormQuestionDAO)manager.lookup(FormQuestionDAO.ROLE);
        this._formPageDAO = (FormPageDAO)manager.lookup(FormPageDAO.ROLE);
        this._formDAO = (FormDAO)manager.lookup(FormDAO.ROLE);
        this._formDirectoryDAO = (FormDirectoryDAO)manager.lookup(FormDirectoryDAO.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void createGenericForms(String sitename) throws Exception {
        Form createdForm = this._createDemoForm(sitename);
        Form surveyForm = this._createSurveyForm(sitename);
        this._fillFormsInService(createdForm, surveyForm);
    }

    private void _fillFormsInService(Form createdForm, Form surveyForm) {
        String query = "//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.forms.service.Display']";
        AmetysObjectIterable zoneItems = this._resolver.query(query);
        for (ModifiableZoneItem zoneItem : zoneItems) {
            ModifiableModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
            if (serviceParameters.hasValue("formId")) continue;
            if (zoneItem.getZone().getName().equals("right")) {
                serviceParameters.setValue("xslt", (Object)"pages/services/display/mini-survey.xsl");
                serviceParameters.setValue("formId", (Object)surveyForm.getId());
            } else {
                serviceParameters.setValue("formId", (Object)createdForm.getId());
            }
            zoneItem.saveChanges();
        }
    }

    private Form _createDemoForm(String sitename) throws Exception {
        Map rootProperties = this._formDirectoryDAO.getFormDirectoryProperties(this._formDirectoryDAO.getFormDirectoriesRootNode(sitename), false);
        Map createFormResult = this._formDAO.createForm(sitename, (String)rootProperties.get("id"), "Demande travaux reprographie");
        String formId = (String)createFormResult.get("id");
        Form form = (Form)this._resolver.resolveById(formId);
        List pages = form.getPages();
        String page1Id = ((FormPage)pages.get(0)).getId();
        this._createFullNameAutoFillSimpleText(page1Id);
        this._createEmailRegexSimpleText(page1Id);
        this._createBasicSimpleText(page1Id);
        Map createPage2Result = this._formPageDAO.createPage(formId, "Page");
        String page2Id = (String)createPage2Result.get("id");
        this._createFile(page2Id);
        this._createNumber(page2Id);
        this._createSimpleCombobox(page2Id);
        this._createMultipleCombobox(page2Id);
        this._createRadioGroup(page2Id);
        this._createCheckBoxGroup(page2Id);
        this._createUniqueCheckBox(page2Id);
        this._createComputedCostField(page2Id);
        this._createDateField(page2Id);
        this._createBasicTextArea(page2Id);
        Map createPageResult = this._formPageDAO.createPage(formId, "Page");
        String page3Id = (String)createPageResult.get("id");
        this._createRichText(page3Id);
        this._createSimpleMatrix(page3Id);
        this._createMultipleMatrix(page3Id);
        this._createDateTime(page3Id);
        form.saveChanges();
        this._formDAO.setWorkflow(formId, "entry-form-default");
        return form;
    }

    private Form _createSurveyForm(String sitename) throws Exception {
        Map rootProperties = this._formDirectoryDAO.getFormDirectoryProperties(this._formDirectoryDAO.getFormDirectoriesRootNode(sitename), false);
        Map createFormResult = this._formDAO.createForm(sitename, (String)rootProperties.get("id"), "Mini-sondage");
        String formId = (String)createFormResult.get("id");
        Form form = (Form)this._resolver.resolveById(formId);
        List pages = form.getPages();
        String firstFormPageId = ((FormPage)pages.get(0)).getId();
        FormQuestion radioGroup = this._createBasicField(firstFormPageId, "form.ChoicesList", "Que pensez-vous du d\u00e9sherbage \u00e0 l'eau chaude comme alternative \u00e0 l'utilisateion du glyphosate?", "S\u00e9lectionner une r\u00e9ponse en cochant la case correspondante", true);
        radioGroup.setValue("format", (Object)"checkbox");
        radioGroup.setValue("source-type", (Object)"org.ametys.plugins.forms.question.sources.Manual");
        radioGroup.setValue("select-grid", (Object)"{\"Je ne connais pas cette alternative\": {\"value\": \"a\"},\"Je ne suis pas convaincu\": {\"value\": \"b\"},\"Je suis convaincu\": {\"value\": \"c\"}}");
        radioGroup.setValue("other-option", (Object)false);
        form.limitToOneEntryByUser(true);
        form.saveChanges();
        return form;
    }

    private void _createDateTime(String pageId) {
        FormQuestion dateTime = this._createBasicField(pageId, "form.DateTime", "Date de la demande", "", false);
        dateTime.setValue("date-format", (Object)"datetime");
        dateTime.setValue("min-datetime", (Object)ZonedDateTime.parse("2024-06-19T22:30:00.000Z"));
        dateTime.setValue("max-datetime", (Object)ZonedDateTime.parse("2024-06-30T22:30:00.000Z"));
    }

    private void _createMultipleMatrix(String pageId) {
        FormQuestion matrix = this._createBasicField(pageId, "form.Matrix", "Mode de livraison", "La description du champ matrice", false);
        matrix.setValue("matrix-grid", (Object)"{\"options\":{\"opt_value\":\"Lundi\",\"opt_value_1\":\"Mardi\",\"opt_value_2\":\"Mercredi\",\"opt_value_3\":\"Jeudi\",\"opt_value_4\":\"Vendredi\"},\"columns\":{\"col_value\":\"Matin\",\"col_value_1\":\"Apr\u00e8s-midi\"}}");
        matrix.setValue("multiple", (Object)true);
    }

    private void _createSimpleMatrix(String pageId) {
        FormQuestion matrix = this._createBasicField(pageId, "form.Matrix", "Mode de livraison", "La description du champ matrice", false);
        matrix.setValue("matrix-grid", (Object)"{\"options\":{\"opt_value\":\"\u00c0 domicile\",\"opt_value_1\":\"En point relai\"},\"columns\":{\"col_value\":\"Rapide (2 jours ouvr\u00e9s)\",\"col_value_1\":\"Normale (3-5 jours)\"}}");
        matrix.setValue("multiple", (Object)false);
    }

    private void _createComputedCostField(String pageId) {
        Map computingResult = this._formQuestionDAO.createQuestion(pageId, "form.Computed");
        FormQuestion computing = (FormQuestion)this._resolver.resolveById((String)computingResult.get("id"));
        computing.setValue("computing-type", (Object)"org.ametys.plugins.forms.question.computing.Cost");
        computing.setValue("title", (Object)"Co\u00fbt de la reprographie");
        computing.setValue("currency", (Object)"euro");
        computing.setValue("confidentiality", (Object)false);
    }

    private void _createRichText(String pageId) {
        Map richTextResult = this._formQuestionDAO.createQuestion(pageId, "form.RichText");
        FormQuestion richText = (FormQuestion)this._resolver.resolveById((String)richTextResult.get("id"));
        String text = "<p><em>What is Lorem Ipsum?</em></p><p><strong>Lorem Ipsum</strong> is simply dummy text of the printing and typesetting industry.</p><ol class=\"arabic\"><li>Lorem Ipsum has been the industry's standard <strong>dummy text</strong> ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</li><li>It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged.</li><li>It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</li></ol>)";
        ModelItem modelItem = richText.getType().getModel().getModelItem("rich-text");
        if (modelItem instanceof ElementDefinition) {
            ElementDefinition definition = (ElementDefinition)modelItem;
            ElementType type = definition.getType();
            Object typedValue = type.fromJSONForClient((Object)text, DataContext.newInstance().withDataPath("rich-text"));
            richText.setValue("rich-text", typedValue);
        }
        richText.setValue("title", (Object)"Champs de test compl\u00e9mentaires");
        richText.setValue("description", (Object)"la description du champ texte riche");
    }

    private void _createDateField(String pageId) {
        FormQuestion date = this._createBasicField(pageId, "form.DateTime", "Date de retour souhait\u00e9e", "", false);
        date.setValue("date-format", (Object)"date");
        date.setValue("min-date", (Object)LocalDate.parse("2024-01-01"));
        date.setValue("max-date", (Object)LocalDate.parse("2024-12-12"));
    }

    private void _createUniqueCheckBox(String pageId) {
        Map checkBoxResult = this._formQuestionDAO.createQuestion(pageId, "form.Checkbox");
        FormQuestion checkbox = (FormQuestion)this._resolver.resolveById((String)checkBoxResult.get("id"));
        checkbox.setValue("title", (Object)"Impression recto/verso");
        checkbox.setValue("is-checked", (Object)true);
        checkbox.setValue("description", (Object)"la description de la case \u00e0 cocher");
    }

    private void _createCheckBoxGroup(String pageId) {
        FormQuestion checkboxGroup = this._createBasicField(pageId, "form.ChoicesList", "Type de papier", "Description du groupe de cases \u00e0 cocher", false);
        checkboxGroup.setValue("format", (Object)"checkbox");
        checkboxGroup.setValue("source-type", (Object)"org.ametys.plugins.forms.question.sources.Manual");
        checkboxGroup.setValue("select-grid", (Object)"{\"Photo\": {\"value\": \"photo\"},\"Adh\u00e9sif\": {\"value\": \"adh_sif\"},\"Simple\": {\"value\": \"simple\"},\"Cartonn\u00e9\": {\"value\": \"carton\"}}");
        checkboxGroup.setValue("other-option", (Object)true);
        checkboxGroup.setValue("multiple", (Object)true);
    }

    private void _createRadioGroup(String pageId) {
        FormQuestion radioGroup = this._createBasicField(pageId, "form.ChoicesList", "Couleur", "Description du groupe radio", false);
        radioGroup.setValue("format", (Object)"checkbox");
        radioGroup.setValue("source-type", (Object)"org.ametys.plugins.forms.question.sources.Manual");
        radioGroup.setValue("select-grid", (Object)"{\"Noir et blanc\": {\"value\": \"noir_et_blanc\"},\"Couleur\": {\"value\": \"couleur\"}}");
        radioGroup.setValue("other-option", (Object)false);
    }

    private void _createMultipleCombobox(String pageId) {
        FormQuestion multiCombobox = this._createBasicField(pageId, "form.ChoicesList", "Format papier de la copie", "Si autre format, pr\u00e9cisez les dimensions en cm", false);
        multiCombobox.setValue("format", (Object)"combobox");
        multiCombobox.setValue("source-type", (Object)"org.ametys.plugins.forms.question.sources.ManualWithCosts");
        multiCombobox.setValue("select-grid-costs", (Object)"{\"A1 (59,4 x 84,1 cm)\": {\"value\": \"a1__59_4_x_84_1_cm_\", \"cost\":0.25},\"A2 (42 x 59,4 cm)\": {\"value\": \"a2__42_59_4_cm_\", \"cost\":0.30},\"A3 (29,7 x 42 cm)\": {\"value\": \"a3__29_7_x_42_cm_\", \"cost\":0.40},\"A4 (21 x 29,7 cm)\": {\"value\": \"a4__21_x_29_7_cm_\", \"cost\":0.50},\"A5 (14,8 x 21 cm)\": {\"value\": \"a5__14_8_x_21_cm_\", \"cost\":1.50}}");
        multiCombobox.setValue("select-grid", (Object)this._getChoiceGrid());
        multiCombobox.setValue("multiple", (Object)true);
    }

    private void _createSimpleCombobox(String pageId) {
        FormQuestion combobox = this._createBasicField(pageId, "form.ChoicesList", "Format papier original", "Description de ma liste \u00e0 choix", false);
        combobox.setValue("format", (Object)"combobox");
        combobox.setValue("source-type", (Object)"org.ametys.plugins.forms.question.sources.Manual");
        combobox.setValue("select-grid-costs", (Object)"{\"A1 (59,4 x 84,1 cm)\": {\"value\": \"a1__59_4_x_84_1_cm_\", \"cost\":0},\"A2 (42 x 59,4 cm)\": {\"value\": \"a2__42_59_4_cm_\", \"cost\":0},\"A3 (29,7 x 42 cm)\": {\"value\": \"a3__29_7_x_42_cm_\", \"cost\":0},\"A4 (21 x 29,7 cm)\": {\"value\": \"a4__21_x_29_7_cm_\", \"cost\":0},\"A5 (14,8 x 21 cm)\": {\"value\": \"a5__14_8_x_21_cm_\", \"cost\":0}}");
        combobox.setValue("select-grid", (Object)this._getChoiceGrid());
        combobox.setValue("other-option", (Object)true);
        combobox.setValue("multiple", (Object)false);
    }

    private String _getChoiceGrid() {
        String choicesOptions = "{\"A1 (59,4 x 84,1 cm)\": {\"value\": \"a1__59_4_x_84_1_cm_\"},\"A2 (42 x 59,4 cm)\": {\"value\": \"a2__42_59_4_cm_\"},\"A3 (29,7 x 42 cm)\": {\"value\": \"a3__29_7_x_42_cm_\"},\"A4 (21 x 29,7 cm)\": {\"value\": \"a4__21_x_29_7_cm_\"},\"A5 (14,8 x 21 cm)\": {\"value\": \"a5__14_8_x_21_cm_\"}}";
        return choicesOptions;
    }

    private void _createNumber(String pageId) {
        FormQuestion number = this._createBasicField(pageId, "form.Number", "Quantit\u00e9 totale", "Description de mon champ nombre", false);
        number.setValue("number-type", (Object)"double");
        number.setValue("min-double", (Object)5.1);
        number.setValue("max-double", (Object)49.3);
    }

    private void _createFile(String pageId) {
        FormQuestion file = this._createBasicField(pageId, "form.File", "Maquette \u00e0 joindre", "Description de mon champ fichier", false);
        file.setValue("extensions", (Object)"_ametys_image_extension");
        file.setValue("max-size", (Object)5);
    }

    private void _createEmailRegexSimpleText(String pageId) {
        FormQuestion textEmail = this._createBasicField(pageId, "form.SimpleText", "Email demandeur", "", false);
        textEmail.setValue("regexp", (Object)"email");
        textEmail.setValue("placeholder", (Object)"toto@exemple.fr");
    }

    private void _createFullNameAutoFillSimpleText(String pageId) {
        FormQuestion textUser = this._createBasicField(pageId, "form.SimpleText", "Nom demandeur", "la description du champ texte", true);
        textUser.setValue("autofill-source", (Object)"org.ametys.plugins.forms.question.autofill.Default");
        textUser.setValue("autofill", (Object)"fullName");
        textUser.setValue("autocomplete", (Object)"name");
    }

    private FormQuestion _createBasicSimpleText(String pageId) {
        return this._createBasicField(pageId, "form.SimpleText", "Service demandeur", "", false);
    }

    private FormQuestion _createBasicTextArea(String pageId) {
        return this._createBasicField(pageId, "form.TextArea", "Pr\u00e9cisions compl\u00e9mentaires", "La description du champ zone de texte", false);
    }

    private FormQuestion _createBasicField(String pageId, String type, String title, String desc, boolean isMandatory) {
        Map fieldResult = this._formQuestionDAO.createQuestion(pageId, type);
        FormQuestion field = (FormQuestion)this._resolver.resolveById((String)fieldResult.get("id"));
        field.setValue("mandatory", (Object)isMandatory);
        field.setValue("title", (Object)title);
        field.setValue("description", (Object)desc);
        return field;
    }
}

