/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.datafiller;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.plugins.datafiller.SitemapPopulator;
import org.ametys.plugins.repository.model.CompositeDefinition;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.MetadataAwareSitemapElement;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageDAO;
import org.ametys.web.repository.page.ServicesAssignmentHandler;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItemManager;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.service.Service;
import org.ametys.web.service.ServiceExtensionPoint;
import org.ametys.web.service.ServiceParameter;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinTemplate;
import org.ametys.web.skin.SkinTemplateZone;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GenericServiceCreationManager
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = GenericServiceCreationManager.class.getName();
    private static final String _SERVICES_PARAMETER_PLUGIN_DIRECTORY = "plugin:data-filler://filling-data/services";
    private static final String _FILE_DIRECTORY_SERVICES_URI = "/WEB-INF/param/datafill/services";
    private I18nUtils _i18nUtils;
    private PageDAO _pageDAO;
    private ServiceExtensionPoint _serviceEP;
    private ServicesAssignmentHandler _serviceHandler;
    private SitemapPopulator _sitemapPopulator;
    private SkinsManager _skinsManager;
    private SourceResolver _sourceResolver;
    private ZoneItemManager _zoneItemManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._pageDAO = (PageDAO)manager.lookup(PageDAO.ROLE);
        this._serviceEP = (ServiceExtensionPoint)manager.lookup(ServiceExtensionPoint.ROLE);
        this._serviceHandler = (ServicesAssignmentHandler)manager.lookup(ServicesAssignmentHandler.ROLE);
        this._sitemapPopulator = (SitemapPopulator)((Object)manager.lookup(SitemapPopulator.ROLE));
        this._skinsManager = (SkinsManager)manager.lookup(SkinsManager.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._zoneItemManager = (ZoneItemManager)manager.lookup(ZoneItemManager.ROLE);
    }

    public Set<String> createGenericServicePages(Sitemap sitemap) throws IOException {
        Set<ServiceObject> createdServices = this._createAllServices();
        ModifiablePage autogeneratedSection = this._sitemapPopulator.getOrCreatePage((MetadataAwareSitemapElement)sitemap, "Test des gabarits");
        HashSet<String> pageWithAttachementId = new HashSet<String>();
        for (ServiceObject service : createdServices) {
            pageWithAttachementId.addAll(this._createPagesForService((Page)autogeneratedSection, service));
        }
        return pageWithAttachementId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ServiceObject> _createAllServices() {
        HashSet<ServiceObject> createdServices = new HashSet<ServiceObject>();
        Set<String> predefinedServices = Set.of("org.ametys.plugins.linkdirectory.DirectoryService.xml", "org.ametys.web.service.FilteredContentsService.xml", "org.ametys.web.service.SitemapService.xml", "org.ametys.plugins.syndication.service.RSS.xml", "org.ametys.web.service.FrontSearchService.xml", "org.ametys.plugins.userdirectory.service.OrganizationChart.xml", "org.ametys.web.service.AttachmentsService.xml", "org.ametys.web.service.SearchService.xml", "org.ametys.web.service.SearchService-user.xml", "org.ametys.forms.service.Display.xml", "org.ametys.plugins.forms.workflow.service.dashboard.xml", "org.ametys.plugins.forms.workflow.service.admin.dashboard.xml");
        TraversableSource servicesDir = null;
        try {
            servicesDir = (TraversableSource)this._sourceResolver.resolveURI("context://WEB-INF/param/datafill/services");
            if (servicesDir.exists()) {
                if (!servicesDir.isCollection()) {
                    throw new IllegalStateException("Root folder for the user defined content must be a folder");
                }
                for (TraversableSource serviceSource : servicesDir.getChildren()) {
                    if (serviceSource.isCollection()) continue;
                    try {
                        createdServices.add(this._createServiceFromFile(serviceSource));
                    }
                    catch (IOException e) {
                        this.getLogger().error("An error occurred: can't create service from file {}", (Object)serviceSource.getURI(), (Object)e);
                    }
                    catch (IllegalStateException | ParserConfigurationException | SAXException e) {
                        this.getLogger().warn("An error occurred while parsing the file {}. Skipping...", (Object)serviceSource.getURI(), (Object)e);
                    }
                }
            }
        }
        catch (IOException e) {
            this.getLogger().info("No folder of user defined content for datafiller in the instance. Continuing with automatically generated content only.", (Throwable)e);
        }
        finally {
            this._sourceResolver.release((Source)servicesDir);
        }
        for (String service : predefinedServices) {
            Source serviceFile = null;
            try {
                serviceFile = this._sourceResolver.resolveURI("plugin:data-filler://filling-data/services/" + service);
                createdServices.add(this._createServiceFromSource(serviceFile));
            }
            catch (IOException e) {
                this.getLogger().warn("An error occured while reading file {}. Skipping...", (Object)service, (Object)e);
            }
            catch (IllegalStateException | ParserConfigurationException | SAXException e) {
                this.getLogger().warn("An error occurred while parsing the file {}. Skipping...", (Object)service, (Object)e);
            }
            finally {
                this._sourceResolver.release(serviceFile);
            }
        }
        return createdServices;
    }

    private ServiceObject _createServiceFromFile(TraversableSource serviceSource) throws ParserConfigurationException, SAXException, IOException, IllegalStateException {
        String fileName = StringUtils.substringAfterLast((String)serviceSource.getURI(), (String)"/");
        String name = StringUtils.substringBefore((String)fileName, (String)".xml");
        String serviceId = StringUtils.contains((CharSequence)name, (CharSequence)"-") ? StringUtils.substringBefore((String)name, (String)"-") : name;
        Service service = (Service)this._serviceEP.getExtension(serviceId);
        if (service != null) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            try (InputStream is = serviceSource.getInputStream();){
                Document doc = docBuilder.parse(is);
                Element root = doc.getDocumentElement();
                Map<String, Object> serviceParameters = this._getServiceParameters(root, service);
                ServiceObject serviceObject = new ServiceObject(this, service, serviceParameters);
                return serviceObject;
            }
        }
        throw new IllegalStateException("No service available for service Id : " + serviceId);
    }

    private ServiceObject _createServiceFromSource(Source source) throws ParserConfigurationException, SAXException, IOException, IllegalStateException {
        String fileName = StringUtils.substringAfterLast((String)source.getURI(), (String)"/");
        String name = StringUtils.substringBefore((String)fileName, (String)".xml");
        String serviceId = StringUtils.contains((CharSequence)name, (CharSequence)"-") ? StringUtils.substringBefore((String)name, (String)"-") : name;
        Service service = (Service)this._serviceEP.getExtension(serviceId);
        if (service != null) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            try (InputStream is = source.getInputStream();){
                Document doc = docBuilder.parse(is);
                Element root = doc.getDocumentElement();
                Map<String, Object> serviceParameters = this._getServiceParameters(root, service);
                ServiceObject serviceObject = new ServiceObject(this, service, serviceParameters);
                return serviceObject;
            }
        }
        throw new IllegalStateException("No service available for service Id : " + serviceId);
    }

    private Map<String, Object> _getServiceParameters(Element root, Service service) {
        HashMap<String, Object> serviceParameters = new HashMap<String, Object>();
        List serviceParameterElementList = DOMUtils.getChildElements((Element)root);
        Map parameters = service.getParameters();
        for (Element serviceParameterNode : serviceParameterElementList) {
            String parameterName = serviceParameterNode.getTagName();
            if (parameters.containsKey(parameterName)) {
                Object value;
                ModelItem modelItem = (ModelItem)parameters.get(parameterName);
                if (modelItem instanceof RepeaterDefinition) {
                    this._handleRepeaterParameters(service, serviceParameters, serviceParameterNode, parameterName, modelItem);
                    continue;
                }
                if (modelItem instanceof CompositeDefinition) {
                    this._handleCompositeParameters(service, serviceParameters, serviceParameterNode, parameterName, modelItem);
                    continue;
                }
                if (!(modelItem instanceof ServiceParameter) || (value = this._getServiceParameter(serviceParameterNode, (ServiceParameter)modelItem)) == null) continue;
                serviceParameters.put(parameterName, value);
                continue;
            }
            this.getLogger().warn("No parameter with name {} defined for service {}", (Object)parameterName, (Object)service.getId());
        }
        return serviceParameters;
    }

    private void _handleCompositeParameters(Service service, Map<String, Object> serviceParameters, Element serviceParameterNode, String parameterName, ModelItem modelItem) {
        CompositeDefinition compositeDef = (CompositeDefinition)modelItem;
        List childAttributeElements = DOMUtils.getChildElements((Element)serviceParameterNode);
        for (Element childAttributeElement : childAttributeElements) {
            String childAttributeName = childAttributeElement.getTagName();
            ModelItem childModelItem = compositeDef.getChild(childAttributeName);
            if (childModelItem != null) {
                if (childModelItem instanceof ServiceParameter) {
                    Object value = this._getServiceParameter(childAttributeElement, (ServiceParameter)childModelItem);
                    if (value == null) continue;
                    String newParameterName = parameterName + "/" + childAttributeName;
                    serviceParameters.put(newParameterName, value);
                    continue;
                }
                this.getLogger().error("Don't handle composite of composite...:(");
                continue;
            }
            this.getLogger().warn("No parameter with name {} defined for service {}", (Object)childAttributeName, (Object)service.getId());
        }
    }

    private void _handleRepeaterParameters(Service service, Map<String, Object> serviceParameters, Element serviceParameterNode, String parameterName, ModelItem modelItem) {
        RepeaterDefinition repeaterDef = (RepeaterDefinition)modelItem;
        List entryElements = DOMUtils.getChildElementsByTagName((Element)serviceParameterNode, (String)"entry");
        serviceParameters.put("_" + parameterName + "/size", entryElements.size());
        for (int k = 0; k < entryElements.size(); ++k) {
            Element repeaterElement = (Element)entryElements.get(k);
            List childAttributeElements = DOMUtils.getChildElements((Element)repeaterElement);
            int entryPosition = k + 1;
            serviceParameters.put("_" + parameterName + "[" + entryPosition + "]/previous-position", -1);
            serviceParameters.put("_" + parameterName + "[" + entryPosition + "]/position", entryPosition);
            for (Element childAttributeElement : childAttributeElements) {
                ModelItem childModelItem = repeaterDef.getChild(childAttributeElement.getTagName());
                if (childModelItem != null) {
                    if (childModelItem instanceof ServiceParameter) {
                        Object value = this._getServiceParameter(childAttributeElement, (ServiceParameter)childModelItem);
                        if (value == null) continue;
                        String newParameterName = parameterName + "[" + entryPosition + "]/" + childAttributeElement.getTagName();
                        serviceParameters.put(newParameterName, value);
                        continue;
                    }
                    this.getLogger().error("Don't handle repeater of repeater...:(");
                    continue;
                }
                this.getLogger().warn("No parameter with name {} defined for service {}", (Object)childAttributeElement.getTagName(), (Object)service.getId());
            }
        }
    }

    private Object _getServiceParameter(Element serviceParameterElement, ServiceParameter serviceParameter) {
        if (StringUtils.isNotBlank((CharSequence)serviceParameterElement.getTextContent())) {
            ElementType newType = serviceParameter.getType();
            if (serviceParameter.isMultiple()) {
                return Arrays.asList(StringUtils.split((String)serviceParameterElement.getTextContent().trim(), (String)"\n")).stream().map(valueAsString -> newType.castValue((Object)valueAsString.trim())).collect(Collectors.toList());
            }
            return newType.castValue((Object)serviceParameterElement.getTextContent());
        }
        return null;
    }

    private Set<String> _createPagesForService(Page rootPage, ServiceObject serviceObject) throws IOException {
        Service service = serviceObject.getService();
        String serviceId = service.getId();
        Site site = rootPage.getSite();
        String language = rootPage.getSitemapName();
        HashSet<String> pageWithAttachementId = new HashSet<String>();
        Skin skin = this._skinsManager.getSkin(site.getSkinId());
        for (String templateId : skin.getTemplates()) {
            if (!this._canCreateTemplate(rootPage.getId(), templateId, templateId)) continue;
            SkinTemplate template = skin.getTemplate(templateId);
            String templateLabel = this._i18nUtils.translate((I18nizable)skin.getTemplate(templateId).getLabel(), language);
            ModifiablePage templatePage = this._sitemapPopulator.getOrCreatePage((MetadataAwareSitemapElement)rootPage, (String)StringUtils.defaultIfBlank((CharSequence)templateLabel, (CharSequence)templateId));
            this._pageDAO.setTemplate(List.of(templatePage.getId()), templateId, false);
            for (SkinTemplateZone skinZone : template.getZones().values()) {
                if (!this._serviceHandler.getAvailableServices((SitemapElement)templatePage, skinZone.getId()).contains(serviceId)) continue;
                I18nizableText servicesTitle = new I18nizableText("plugin.data-filler", "PLUGINS_DATA_FILLER_CREATE_TEST_PAGE_SERVICES_PAGE_TITLE");
                ModifiablePage servicesPage = this._sitemapPopulator.getOrCreatePage((MetadataAwareSitemapElement)templatePage, this._i18nUtils.translate((I18nizable)servicesTitle, rootPage.getSitemapName()));
                String servicePageTitle = (String)serviceObject.getParameters().get("header");
                servicePageTitle = servicePageTitle == null ? this._i18nUtils.translate((I18nizable)service.getLabel(), rootPage.getSitemapName()) : servicePageTitle;
                ModifiablePage servicePage = this._sitemapPopulator.getOrCreatePage((MetadataAwareSitemapElement)servicesPage, servicePageTitle);
                String zoneLabel = this._i18nUtils.translate((I18nizable)skinZone.getLabel(), language);
                ModifiablePage zonePage = this._sitemapPopulator.getOrCreatePage((MetadataAwareSitemapElement)servicePage, (String)StringUtils.defaultIfBlank((CharSequence)zoneLabel, (CharSequence)skinZone.getId()));
                this._pageDAO.setTemplate(List.of(zonePage.getId()), templateId, false);
                this._zoneItemManager.addService(zonePage.getId(), skinZone.getId(), serviceId, serviceObject.getParameters());
                if (!serviceId.equals("org.ametys.web.service.AttachmentsService")) continue;
                pageWithAttachementId.add(zonePage.getId());
            }
            this._pageDAO.setBlank(List.of(templatePage.getId()));
        }
        return pageWithAttachementId;
    }

    private boolean _canCreateTemplate(String parentId, String pageTitle, String templateId) {
        List availableTemplatesForCreation = this._pageDAO.getAvailableTemplatesForCreation(null, parentId, pageTitle);
        return availableTemplatesForCreation.parallelStream().filter(map -> templateId.equals(map.get("id"))).findAny().isPresent();
    }

    private class ServiceObject {
        private Service _service;
        private Map<String, Object> _parameters;

        public ServiceObject(GenericServiceCreationManager genericServiceCreationManager, Service service, Map<String, Object> parameters) {
            this.setService(service);
            this.setParameters(parameters);
        }

        public Service getService() {
            return this._service;
        }

        public void setService(Service service) {
            this._service = service;
        }

        public Map<String, Object> getParameters() {
            return this._parameters;
        }

        public void setParameters(Map<String, Object> parameters) {
            this._parameters = parameters;
        }
    }
}

