/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.datafiller;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ametys.cms.repository.ContentDAO;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.MetadataAwareSitemapElement;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.PageDAO;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SitemapPopulator
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = SitemapPopulator.class.getName();
    private PageDAO _pageDAO;
    private AmetysObjectResolver _resolver;
    private Map<String, String> _createdPageIds;

    public void initialize() throws Exception {
        this._createdPageIds = new HashMap<String, String>();
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._pageDAO = (PageDAO)manager.lookup(PageDAO.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void createSitemap(Sitemap sitemap, Source source) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        try (InputStream is = source.getInputStream();){
            Document doc = docBuilder.parse(is);
            Element root = doc.getDocumentElement();
            this._createPagesForSitemap(root, sitemap);
        }
    }

    public Map<String, String> getCreatedPages() {
        return this._createdPageIds;
    }

    public void deletePage(ModifiablePage page) {
        String parentPath = ((SitemapElement)page.getParent()).getPathInSitemap();
        String key = this._getPageKey(page.getTitle(), parentPath, page.getSitemapName());
        this._pageDAO.deletePage(page, true);
        this._createdPageIds.remove(key);
    }

    private void _createPagesForSitemap(Element root, Sitemap sitemap) {
        List pageElementList = DOMUtils.getChildElementsByTagName((Element)root, (String)"page");
        for (Element pageElement : pageElementList) {
            this._createPageForSitemap((MetadataAwareSitemapElement)sitemap, pageElement, sitemap.getSitemapName());
        }
    }

    private void _createPageForSitemap(MetadataAwareSitemapElement parentPage, Element pageElement, String sitemapName) {
        String template;
        String tags;
        String title = pageElement.getAttribute("title");
        if (StringUtils.isBlank((CharSequence)title)) {
            this.getLogger().error("Can't create page because no title is defined");
            return;
        }
        String titleLong = pageElement.getAttribute("longtitle");
        String name = pageElement.getAttribute("name");
        ModifiablePage page = this.getOrCreatePage(parentPage, StringUtils.isNotBlank((CharSequence)name) ? name : title, titleLong);
        page.setTitle(title);
        page.saveChanges();
        List subPageElementList = DOMUtils.getChildElementsByTagName((Element)pageElement, (String)"page");
        for (Element subPageElement : subPageElementList) {
            this._createPageForSitemap((MetadataAwareSitemapElement)page, subPageElement, sitemapName);
        }
        boolean invisible = pageElement.getAttribute("invisible").equals("true");
        if (invisible) {
            this._pageDAO.setVisibility(List.of(page.getId()), true);
        }
        if (StringUtils.isNotBlank((CharSequence)(tags = pageElement.getAttribute("tags")))) {
            for (String tag : StringUtils.split((String)tags, (String)",")) {
                try {
                    this._pageDAO.tag(List.of(page.getId()), List.of(tag), ContentDAO.TagMode.INSERT, new HashMap(), true);
                }
                catch (Exception e) {
                    this.getLogger().warn("Failed to tag page '{}' with tags '{}'.", new Object[]{page.getPathInSitemap(), tags, e});
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(template = pageElement.getAttribute("template")))) {
            try {
                this._pageDAO.setTemplate(List.of(page.getId()), template);
            }
            catch (IllegalStateException e) {
                this.getLogger().warn("Failed to set template for page {}", (Object)title, (Object)e);
            }
        }
    }

    public ModifiablePage getOrCreatePage(MetadataAwareSitemapElement parentPage, String title) {
        return this.getOrCreatePage(parentPage, title, "");
    }

    public ModifiablePage getOrCreatePage(MetadataAwareSitemapElement parentPage, String title, String titleLong) {
        String key = this._getPageKey(title, parentPage.getPathInSitemap(), parentPage.getSitemapName());
        ModifiablePage page = this._getPage(key);
        if (page == null) {
            page = this._createPage(parentPage, title, titleLong, key);
        }
        return page;
    }

    private ModifiablePage _getPage(String key) {
        if (this._createdPageIds.containsKey(key)) {
            try {
                return (ModifiablePage)this._resolver.resolveById(this._createdPageIds.get(key));
            }
            catch (UnknownAmetysObjectException e) {
                this._createdPageIds.remove(key);
            }
        }
        return null;
    }

    private ModifiablePage _createPage(MetadataAwareSitemapElement parentPage, String title, String titleLong, String key) {
        Map viewPageResult = this._pageDAO.createPage(parentPage.getId(), title, titleLong);
        String pageId = (String)viewPageResult.get("id");
        this._createdPageIds.put(key, pageId);
        return (ModifiablePage)this._resolver.resolveById(pageId);
    }

    private String _getPageKey(String title, String parentPath, String lang) {
        StringBuilder sb = new StringBuilder();
        sb.append(lang).append("#");
        if (StringUtils.isNotEmpty((CharSequence)parentPath)) {
            sb.append("/").append(parentPath);
        }
        sb.append("/").append(title);
        return sb.toString();
    }
}

