/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.externaldata.cache;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.web.cache.FOCommHelper;
import org.ametys.web.cache.pageelement.PageElementCache;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.synchronization.AbstractSynchronizeObserver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class InvalidateCacheOnQueryChangesObserver
extends AbstractSynchronizeObserver {
    private PageElementCache _inputDataCache;
    private PageElementCache _zoneItemCache;
    private SiteManager _siteManager;
    private FOCommHelper _foCommHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._inputDataCache = (PageElementCache)manager.lookup(PageElementCache.ROLE + "/inputData");
        this._zoneItemCache = (PageElementCache)manager.lookup(PageElementCache.ROLE + "/zoneItem");
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._foCommHelper = (FOCommHelper)manager.lookup(FOCommHelper.ROLE);
    }

    public boolean supports(Event event) {
        return event.getId().equals("query.updated") || event.getId().equals("query.deleted");
    }

    protected void _internalObserve(Event event, Session liveSession) throws RepositoryException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Database changes: " + String.valueOf(event) + ", invalidating cache");
        }
        AmetysObjectIterable sites = this._siteManager.getSites();
        for (Site site : sites) {
            try {
                this._foCommHelper.invalidateFOCache(site);
            }
            catch (Exception e) {
                this.getLogger().error("Unable to clear cache of site " + site.getName(), (Throwable)e);
            }
        }
        this._inputDataCache.clear();
        this._zoneItemCache.clear();
    }
}

