/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.externaldata.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.ametys.plugins.externaldata.data.Query;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractQuery
implements Query {
    protected String _id;
    protected String _name;
    protected String _description;
    protected Map<String, String> _parameters;
    protected Query.ResultType _resultType;
    protected String _dataSourceId;
    protected String _factoryId;

    @Override
    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public Query.ResultType getResultType() {
        return this._resultType;
    }

    public void setResultType(Query.ResultType resultType) {
        this._resultType = resultType;
    }

    @Override
    public String getFactory() {
        return this._factoryId;
    }

    public void setFactory(String factoryId) {
        this._factoryId = factoryId;
    }

    @Override
    public String getDataSourceId() {
        return this._dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this._dataSourceId = dataSourceId;
    }

    protected Map<String, String> _buildParameters(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (query != null) {
            Matcher matcher = Query.PARAMETER_MATCHER.matcher(query);
            ArrayList<String> paramWithLabel = new ArrayList<String>();
            while (matcher.find()) {
                String paramName;
                if (matcher.groupCount() == 1) {
                    paramName = matcher.group(1).toLowerCase();
                    if (params.containsKey(paramName) && paramWithLabel.contains(paramName)) continue;
                    params.put(paramName, paramName);
                    continue;
                }
                if (matcher.groupCount() <= 2) continue;
                paramName = matcher.group(1).toLowerCase();
                String label = matcher.group(3);
                if (StringUtils.isBlank((CharSequence)label)) {
                    label = paramName;
                    paramWithLabel.add(paramName);
                }
                if (params.containsKey(paramName) && paramWithLabel.contains(paramName)) continue;
                params.put(paramName, label);
            }
        }
        return params;
    }
}

