/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.externaldata.data;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.ametys.plugins.externaldata.data.DataInclusionException;
import org.ametys.plugins.externaldata.data.DataSourceFactory;
import org.ametys.plugins.externaldata.data.DataSourceFactoryExtensionPoint;
import org.ametys.plugins.externaldata.data.Query;
import org.ametys.plugins.externaldata.data.QueryDao;
import org.ametys.plugins.externaldata.data.QueryResult;
import org.ametys.plugins.externaldata.data.QueryResultRow;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExternalSearchGenerator
extends ServiceableGenerator {
    private static final String __SEARCH_CRITERIA_PREFIX = "external-data-search-";
    protected QueryDao _queryDao;
    protected DataSourceFactoryExtensionPoint _dataSourceFactoryEP;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._queryDao = (QueryDao)smanager.lookup(QueryDao.ROLE);
        this._dataSourceFactoryEP = (DataSourceFactoryExtensionPoint)((Object)smanager.lookup(DataSourceFactoryExtensionPoint.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String currentSiteName = null;
        String lang = null;
        Page page = (Page)request.getAttribute(Page.class.getName());
        if (page != null) {
            currentSiteName = page.getSiteName();
            lang = page.getSitemapName();
        }
        String siteName = (String)request.getAttribute("site");
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(ZoneItem.class.getName());
        String idQuery = (String)zoneItem.getServiceParameters().getValue("datasource-query");
        int limit = Math.toIntExact((Long)zoneItem.getServiceParameters().getValue("limit"));
        int pageNum = this.getPageIndex(request);
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"search");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"url", (String)(page != null ? lang + "/" + page.getPathInSitemap() + ".html" : lang + "/_plugins/" + currentSiteName + "/" + lang + "/service/search.html"));
        try {
            boolean submit;
            Query query = this._queryDao.getQuery(siteName, idQuery);
            Map<String, String> parameterValues = this.getParameterValues(request, query);
            this.saxFormParameters(request, query, parameterValues);
            boolean bl = submit = request.getParameter("external-data-search-submit") != null;
            if (submit) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"search-result");
                this.executeQuery(query, parameterValues, limit, pageNum);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"search-result");
            }
        }
        catch (DataInclusionException e) {
            this.getLogger().error("An error occurred : impossible to get query with id : " + idQuery, (Throwable)e);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"search");
        this.contentHandler.endDocument();
    }

    protected Map<String, String> getParameterValues(Request request, Query query) {
        HashMap<String, String> paramValues = new HashMap<String, String>();
        Map<String, String> parametersName = query.getParameters();
        for (String paramName : parametersName.keySet()) {
            String value = request.getParameter(__SEARCH_CRITERIA_PREFIX + paramName);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            paramValues.put(paramName, value);
        }
        return paramValues;
    }

    protected void saxFormParameters(Request request, Query query, Map<String, String> values) throws SAXException {
        boolean submit;
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"form");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"fields");
        this.saxFormFields(query);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"fields");
        boolean bl = submit = request.getParameter("external-data-search-submit") != null;
        if (submit) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"values");
            this.saxFormValues(request, values);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"values");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"form");
    }

    protected void saxFormFields(Query query) throws SAXException {
        Map<String, String> parametersName = query.getParameters();
        for (Map.Entry<String, String> entry : parametersName.entrySet()) {
            String parameterName = entry.getKey();
            String paramaterLabel = entry.getValue();
            AttributesImpl att = new AttributesImpl();
            att.addCDATAAttribute("id", parameterName);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"field", (Attributes)att, (String)paramaterLabel);
        }
    }

    protected void saxFormValues(Request request, Map<String, String> values) throws SAXException {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String paramName = entry.getKey();
            String paramValue = entry.getValue();
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)paramName, (String)paramValue);
        }
    }

    protected void executeQuery(Query query, Map<String, String> parameterValues, int nbResultsPerPage, int page) throws DataInclusionException, SAXException {
        String factoryId = query.getFactory();
        DataSourceFactory dsFactory = (DataSourceFactory)this._dataSourceFactoryEP.getExtension(factoryId);
        int offset = (page - 1) * nbResultsPerPage;
        Object result = dsFactory.execute(query, parameterValues, offset, nbResultsPerPage);
        this.saxResult(query, (QueryResult)result);
        boolean hasMoreElmts = false;
        int nbResults = result.getSize();
        if (nbResults >= nbResultsPerPage) {
            hasMoreElmts = dsFactory.execute(query, parameterValues, page * nbResultsPerPage, 1).getSize() > 0;
        }
        this.saxPagination(page, offset, nbResultsPerPage, result.getSize(), hasMoreElmts);
    }

    protected void saxPagination(int page, int offset, int limit, int nbResult, boolean hasMoreResult) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("start", String.valueOf(offset));
        atts.addCDATAAttribute("end", String.valueOf(offset + nbResult));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"pagination", (Attributes)atts);
        int nbPage = page;
        if (hasMoreResult) {
            ++nbPage;
        }
        for (int i = 1; i <= nbPage; ++i) {
            AttributesImpl attPage = new AttributesImpl();
            attPage.addCDATAAttribute("index", String.valueOf(i));
            attPage.addCDATAAttribute("start", String.valueOf((i - 1) * limit));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"page", (Attributes)attPage);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"pagination");
    }

    protected void saxResult(Query query, QueryResult result) throws SAXException {
        String queryId = query.getId();
        try {
            this.contentHandler.processingInstruction("ametys-unmodifiable", "start");
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("class", "data " + queryId);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"table", (Attributes)atts);
            Collection<String> colNames = result.getColumnNames();
            if (!colNames.isEmpty()) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"tr");
                for (String columnName : colNames) {
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"th", (String)columnName);
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"tr");
            }
            int index = 0;
            for (QueryResultRow row : result) {
                AttributesImpl attr = new AttributesImpl();
                if (index % 2 != 0) {
                    attr.addAttribute("", "class", "class", "CDATA", "odd");
                } else {
                    attr.addAttribute("", "class", "class", "CDATA", "even");
                }
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"tr", (Attributes)attr);
                for (String columnName : colNames) {
                    String value = row.get(columnName);
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"td", (String)StringUtils.defaultString((String)value));
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"tr");
                ++index;
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"table");
            this.contentHandler.processingInstruction("ametys-unmodifiable", "end");
        }
        catch (DataInclusionException e) {
            String message = "Unable to get the query results (query ID : " + queryId + ")";
            this.getLogger().error(message, (Throwable)e);
            throw new SAXException(message, e);
        }
        finally {
            result.close();
        }
    }

    protected int getPageIndex(Request request) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String param = (String)paramNames.nextElement();
            if (!param.startsWith("page-")) continue;
            return Integer.parseInt(param.substring("page-".length()));
        }
        return 1;
    }
}

