/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.externaldata.data.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.ametys.plugins.externaldata.data.DataInclusionException;
import org.ametys.plugins.externaldata.data.Query;
import org.ametys.plugins.externaldata.data.QueryResult;
import org.ametys.plugins.externaldata.data.QueryResultRow;
import org.ametys.plugins.externaldata.data.ldap.LdapQueryResultRow;

public class LdapQueryResult
implements QueryResult {
    protected Query.ResultType _resultType;
    protected List<QueryResultRow> _rows;
    protected List<String> _columnNames;
    protected Map<String, String> _attributes;

    public LdapQueryResult(List<SearchResult> results, List<String> columnNames, Map<String, String> attributes) {
        try {
            this._columnNames = columnNames;
            this._attributes = attributes;
            this._extractResults(results, columnNames, attributes);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Query.ResultType getType() {
        return this._resultType;
    }

    public void setType(Query.ResultType resultType) {
        this._resultType = resultType;
    }

    @Override
    public int getSize() {
        return this._rows.size();
    }

    @Override
    public Collection<String> getColumnNames() throws DataInclusionException {
        return this._columnNames;
    }

    @Override
    public Iterator<QueryResultRow> iterator() {
        return this._rows.iterator();
    }

    @Override
    public void close() {
    }

    protected void _extractResults(List<SearchResult> results, List<String> columnNames, Map<String, String> attributes) throws NamingException {
        this._rows = new ArrayList<QueryResultRow>();
        for (SearchResult result : results) {
            Attributes attrs = result.getAttributes();
            LdapQueryResultRow row = new LdapQueryResultRow();
            for (String colName : this._columnNames) {
                String attrId = attributes.get(colName);
                Attribute attrValue = attrs.get(attrId);
                if (attrValue == null) continue;
                row.put(colName, (String)attrValue.get());
            }
            this._rows.add(row);
        }
    }
}

