/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.externaldata.data.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.plugins.externaldata.data.DataInclusionException;
import org.ametys.plugins.externaldata.data.Query;
import org.ametys.plugins.externaldata.data.QueryResult;
import org.ametys.plugins.externaldata.data.QueryResultRow;
import org.ametys.plugins.externaldata.data.sql.SqlQueryResultRow;

public class LazySqlQueryResult
implements QueryResult,
Iterator<QueryResultRow> {
    protected Query.ResultType _resultType;
    protected ResultSet _resultSet;
    private Collection<String> _columnNames;

    public LazySqlQueryResult(ResultSet resultSet) {
        this._resultSet = resultSet;
        try {
            this._columnNames = this._extractColumnNames(this._resultSet);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Query.ResultType getType() {
        return this._resultType;
    }

    @Override
    public int getSize() {
        try {
            return this._resultSet.getFetchSize();
        }
        catch (SQLException e) {
            return -1;
        }
    }

    public void setType(Query.ResultType resultType) {
        this._resultType = resultType;
    }

    @Override
    public Collection<String> getColumnNames() throws DataInclusionException {
        try {
            if (this._columnNames == null) {
                this._columnNames = this._extractColumnNames(this._resultSet);
            }
            return this._columnNames;
        }
        catch (SQLException e) {
            throw new DataInclusionException("Unable to retrieve the column names.", e);
        }
    }

    @Override
    public Iterator<QueryResultRow> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        try {
            return this._resultSet.next();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryResultRow next() {
        try {
            SqlQueryResultRow row = new SqlQueryResultRow();
            for (String colName : this.getColumnNames()) {
                String value = this._resultSet.getString(colName);
                row.put(colName, value);
            }
            return row;
        }
        catch (DataInclusionException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operation not supported.");
    }

    @Override
    public void close() {
        ConnectionHelper.cleanup((ResultSet)this._resultSet);
    }

    protected Collection<String> _extractColumnNames(ResultSet resultSet) throws SQLException {
        ResultSetMetaData rsMeta = resultSet.getMetaData();
        int count = rsMeta.getColumnCount();
        ArrayList<String> columns = new ArrayList<String>(count);
        for (int i = 1; i <= count; ++i) {
            columns.add(rsMeta.getColumnLabel(i));
        }
        return columns;
    }
}

