/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.externaldata.data.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ametys.plugins.externaldata.data.DataInclusionException;
import org.ametys.plugins.externaldata.data.Query;
import org.ametys.plugins.externaldata.data.QueryResult;
import org.ametys.plugins.externaldata.data.QueryResultRow;
import org.ametys.plugins.externaldata.data.sql.SqlQueryResultRow;

public class SqlQueryResult
implements QueryResult {
    protected Query.ResultType _resultType;
    protected List<QueryResultRow> _rows;
    private Collection<String> _columnNames;

    public SqlQueryResult(ResultSet resultSet) {
        try {
            this._extractResults(resultSet);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Query.ResultType getType() {
        return this._resultType;
    }

    @Override
    public int getSize() {
        return this._rows.size();
    }

    public void setType(Query.ResultType resultType) {
        this._resultType = resultType;
    }

    @Override
    public Collection<String> getColumnNames() throws DataInclusionException {
        return this._columnNames;
    }

    @Override
    public Iterator<QueryResultRow> iterator() {
        return this._rows.iterator();
    }

    @Override
    public void close() {
    }

    protected void _extractResults(ResultSet resultSet) throws SQLException {
        ResultSetMetaData rsMeta = resultSet.getMetaData();
        int count = rsMeta.getColumnCount();
        this._columnNames = new ArrayList<String>(count);
        for (int i = 1; i <= count; ++i) {
            String columnLabel = rsMeta.getColumnLabel(i);
            if ("rnum".equals(columnLabel.toLowerCase())) continue;
            this._columnNames.add(rsMeta.getColumnLabel(i));
        }
        this._rows = new ArrayList<QueryResultRow>();
        while (resultSet.next()) {
            SqlQueryResultRow row = new SqlQueryResultRow();
            for (String colName : this._columnNames) {
                String value = resultSet.getString(colName);
                row.put(colName, value);
            }
            this._rows.add(row);
        }
    }
}

