/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.externaldata.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.datasource.DataSourceClientInteraction;
import org.ametys.plugins.externaldata.data.DataSourceFactoryExtensionPoint;
import org.ametys.plugins.externaldata.data.Query;
import org.ametys.plugins.externaldata.data.QueryDao;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetDataSourceQueriesAction
extends ServiceableAction {
    protected DataSourceClientInteraction _dataSourceClientInteraction;
    protected DataSourceFactoryExtensionPoint _dataSourceFactoryEP;
    protected QueryDao _queryDao;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._dataSourceClientInteraction = (DataSourceClientInteraction)smanager.lookup(DataSourceClientInteraction.ROLE);
        this._dataSourceFactoryEP = (DataSourceFactoryExtensionPoint)((Object)smanager.lookup(DataSourceFactoryExtensionPoint.ROLE));
        this._queryDao = (QueryDao)smanager.lookup(QueryDao.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = (Map)objectModel.get("parent-context");
        String siteName = (String)jsParameters.get("siteName");
        String nodeId = (String)jsParameters.get("node");
        String nodeType = (String)jsParameters.get("nodeType");
        String resultTypeFilter = (String)jsParameters.get("resultType");
        Query.ResultType resultType = null;
        if (StringUtils.isNotEmpty((CharSequence)resultTypeFilter)) {
            resultType = Query.ResultType.valueOf(resultTypeFilter);
        }
        List dataSourceTypeFilter = (List)jsParameters.get("dataSourceType");
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        if ("root".equals(nodeType) || StringUtils.isBlank((CharSequence)nodeType)) {
            if (dataSourceTypeFilter != null && !dataSourceTypeFilter.isEmpty()) {
                for (Object type : dataSourceTypeFilter) {
                    nodes.add(this.dataSourceTypeToJSON(DataSourceClientInteraction.DataSourceType.valueOf((String)type)));
                }
            } else {
                Collection<DataSourceClientInteraction.DataSourceType> allTypes = this._dataSourceFactoryEP.getAllTypes();
                for (DataSourceClientInteraction.DataSourceType type : allTypes) {
                    nodes.add(this.dataSourceTypeToJSON(type));
                }
            }
        } else if ("dataSourceType".equals(nodeType)) {
            DataSourceClientInteraction.DataSourceType dataSourceType = DataSourceClientInteraction.DataSourceType.valueOf((String)nodeId);
            List dataSources = this._dataSourceClientInteraction.getDataSources(dataSourceType, false, false, false, null);
            for (Map dataSource : dataSources) {
                Collection<Query> queries = this._queryDao.getDataSourceQueries(siteName, (String)dataSource.get("id"), resultType).values();
                dataSource.put("leaf", queries.isEmpty());
                dataSource.put("type", "datasource");
                dataSource.put("dataSourceType", dataSourceType.name());
                nodes.add(dataSource);
            }
        } else if ("datasource".equals(nodeType)) {
            for (Query query : this._queryDao.getDataSourceQueries(siteName, nodeId, null, resultType).values()) {
                nodes.add(this.queryToJSON(query));
            }
        }
        HashMap<String, ArrayList<Map<String, Object>>> result = new HashMap<String, ArrayList<Map<String, Object>>>();
        result.put("children", nodes);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected Map<String, Object> dataSourceTypeToJSON(DataSourceClientInteraction.DataSourceType dataSourceType) throws Exception {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", dataSourceType.name());
        infos.put("type", "dataSourceType");
        infos.put("dataSourceType", dataSourceType.name());
        infos.put("name", dataSourceType.name());
        List dataSources = this._dataSourceClientInteraction.getDataSources(dataSourceType, false, false, false, null);
        infos.put("leaf", dataSources.isEmpty());
        return infos;
    }

    protected Map<String, Object> queryToJSON(Query query) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", query.getId());
        infos.put("type", "query");
        infos.put("dataSourceType", query.getType());
        infos.put("name", query.getName());
        infos.put("description", query.getDescription());
        infos.put("resultType", query.getResultType().name());
        infos.put("leaf", true);
        Map<String, String> additionalConf = query.getAdditionalConfiguration();
        for (String confName : additionalConf.keySet()) {
            String value = additionalConf.get(confName);
            infos.put(confName, value);
        }
        infos.put("parameters", query.getParameters());
        return infos;
    }
}

