/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 /**
 * Singleton class to handle actions on data sources.
 * @private
 */
 Ext.define('Ametys.plugins.externaldata.QueriesActions', {
 	singleton: true,
 	
 	/**
 	 * Creates a new query.
 	 * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function.
 	 */
 	addQuery: function(controller)
 	{
 		this._mode = 'new';
 		
 		var targets = controller.getMatchingTargets();
 		var target = Ametys.message.MessageTargetHelper.findTarget(targets, Ametys.message.MessageTarget.EXTERNAL_DATASOURCE);
 		
 		// FIXME The helper to use should be provided by the DataSourceExtensionPoint
 		if (target.getParameters().dataSourceType == 'LDAP')
 		{
 			Ametys.plugins.externaldata.helper.LDAPQuery.add(target.getParameters().id);
 		}
 		else if (target.getParameters().dataSourceType == 'SQL')
 		{
 			Ametys.plugins.externaldata.helper.SQLQuery.add(target.getParameters().id);
 		}
 	},
 	
 	/**
 	 * Edits the current selected query
 	 * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function.
 	 */
 	editQuery: function(controller)
 	{
 		this._mode = 'edit';
 		
 		var targets = controller.getMatchingTargets();
 		var target = Ametys.message.MessageTargetHelper.findTarget(targets, Ametys.message.MessageTarget.EXTERNAL_DATASOURCE_QUERY)
 		
 		// FIXME The helper to use should be provided by the DataSourceExtensionPoint
 		if (target.getParameters().dataSourceType == 'LDAP')
 		{
 			Ametys.plugins.externaldata.helper.LDAPQuery.edit(target.getParameters().id);
 		}
 		else if (target.getParameters().dataSourceType == 'SQL')
 		{
 			Ametys.plugins.externaldata.helper.SQLQuery.edit(target.getParameters().id);
 		}
 	},
 	
 	/**
 	 * Deletes the current selected query
 	 * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function.
 	 */
 	deleteQuery: function(controller)
 	{
 		var target = controller.getMatchingTargets()[0];
 		
 		if (target != null)
 		{
 			Ametys.Msg.confirm("{{i18n PLUGINS_EXTERNAL_DATA_HANDLE_QUERIES_DELETE_QUERY_LABEL}}",
 	 				"{{i18n PLUGINS_EXTERNAL_DATA_HANDLE_QUERIES_DELETE_QUERY_CONFIRM}}",
 	 				Ext.bind(this._doDelete, this, [target.getParameters().id], 1),
 	 				this
 	 		);
 		}
 	},
 	
 	/**
 	 * The action to perform when the user clicks on a button from the deleting message box.
 	 * @param {String} btn The pressed button. Can only be 'yes'/'no'
 	 * @param {String} queryId The id of the query to delete
 	 * @private
 	 */
 	_doDelete: function(btn, queryId)
 	{
 		if (btn == 'yes')
	    {
	        Ametys.cms.externaldata.QueryDAO.deleteQuery([Ametys.getAppParameter('siteName'), queryId]);
	    }
 	}
 });