/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
/**
 * Enables to insert a query in the text.
 * @private
 */
Ext.define('Ametys.plugins.externaldata.editor.QueryEditor', {
	singleton: true,
	
	/**
	 * Opens the "add query" dialog.
	 * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function.
	 */
	addQuery: function(controller)
	{
		var pluginName = controller.getPluginName();
		Ametys.plugins.externaldata.helper.ChooseQuery.open({
			title: "{{i18n PLUGINS_EXTERNAL_DATA_EDITOR_QUERY_TITLE}}",
            helpmessage: "{{i18n PLUGINS_EXTERNAL_DATA_EDITOR_QUERY_HELPMESSAGE}}",
            callback: Ext.bind(this._callback, this),
            siteName: Ametys.getAppParameter('siteName')
		});
	},
	
	/**
	 * Enable/disable controller if the current selected node is a query.
	 * @param {Ametys.cms.editor.EditorButtonController} controller The controller.
	 * @param {Ametys.cms.form.widget.RichText} field The current field. Can be null
	 * @param {HTMLElement} node The current selected node. Can be null.
	 */
	querySelectionListener: function(controller, field, node)
	{
        var elt = field != null && node != null ? field.getEditor().dom.getParent(field.getEditor().selection.getNode(), 'img[datainclusion]') : null;
    	
    	var toggleState = elt != null && elt.nodeName.toLowerCase() == 'img';
    	
        controller.toggle(node != null && toggleState);
	},
	
	/**
	 * Insert Query callback : called when a query was selected.
	 * @param {String} queryId The query id
	 * @param {String} title The title
	 * @private
	 */
	_callback: function(queryId, title)
	{
	    // FIXME "tinyMCE.activeEditor" a better method is to use the field.getEditor()
	    tinyMCE.activeEditor.focus();
	    if (queryId != null)
	    {
	        var id = Ext.id();
	        
	        tinyMCE.activeEditor.execCommand('mceBeginUndoLevel');
	        tinyMCE.activeEditor.execCommand('mceInsertContent', false, this._createHTML(queryId, title));
	        tinyMCE.activeEditor.execCommand('mceEndUndoLevel');
	        
	        node = tinyMCE.activeEditor.dom.get(id);
	        if (node != null)
	        {
	            tinyMCE.activeEditor.selection.select(node);
	        }
	    }
	},
	
	/**
	 * Creates the HTMl to insert
	 * @param {String} queryId The id
	 * @param {String} title The title
	 * @return {String} The HTMl to insert
	 * @private
	 */
	_createHTML: function(queryId, title)
	{
		var alt = title == null ? '' : title;
    	return "<img queryid='" + queryId + "' alt='" + alt + "' marker='marker' datainclusion='query' class='datainclusion-query mceItemNoResize' src='" + Ametys.getPluginResourcesPrefix('external-data') + "/img/content/edition/trans.gif'/>";
	}
	
});