/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This helper provides common method for queries
 */
Ext.define('Ametys.plugins.externaldata.helper.Query', {
	singleton: true,
	
	/**
	 * Get the common form items for all type of queries
	 * @param {String} type The data source type
	 * @return {Object[]} The items configuration
	 */
	getCommonFormItems: function (type)
	{
		var model = Ext.create('Ext.data.Model', {
 			fields: [
				'id', 
				'name'
			]
 		});
		
 		var datasourceStore = Ext.create('Ext.data.Store', {
 			model: model,
 			autoLoad: false,
 			proxy: {
				type: 'ametys',
				plugin: 'external-data',
				url: 'datasources.json',
				reader: {
					type: 'json',
					rootProperty: 'datasources'
				},
				extraParams: {
					siteName: Ametys.getAppParameter('siteName'),
					type: type
				}
			}
 		});
 		
		return [
			{
				xtype: 'hidden',
				name: 'id'
			},
			{
				xtype: 'hidden',
				name: 'type'
			},
			{
				xtype: 'combobox',
				fieldLabel : "* {{i18n PLUGINS_EXTERNAL_DATA_UI_HELPER_QUERY_DATASOURCE}}",
				ametysDescription: "{{i18n PLUGINS_EXTERNAL_DATA_UI_HELPER_QUERY_DATASOURCE_DESC}}",
				queryMode: 'local',
			    allowBlank: false,
			    forceSelection: true,
			    triggerAction: 'all',
			    name: 'dataSourceId',
			    valueField: 'id',
				displayField: 'name',
			    store: datasourceStore
			},
			{
				xtype: 'textfield',
				name: 'name',
				itemId: 'name',
				fieldLabel : "* {{i18n PLUGINS_EXTERNAL_DATA_UI_HELPER_QUERY_NAME}}",
				ametysDescription: "{{i18n PLUGINS_EXTERNAL_DATA_UI_HELPER_QUERY_NAME_DESC}}",
				allowBlank: false
			},
			{
				xtype: 'textarea',
				name: 'description',
				fieldLabel: "{{i18n PLUGINS_EXTERNAL_DATA_UI_HELPER_QUERY_DESCRIPTION}}",
				ametysDescription: "{{i18n PLUGINS_EXTERNAL_DATA_UI_HELPER_QUERY_DESCRIPTION_DESC}}",
				height: 70
			},
			{
				xtype: 'radiogroup',
				name: 'resultTypeGroup',
				fieldLabel: "{{i18n PLUGINS_EXTERNAL_DATA_UI_HELPER_QUERY_RESULTTYPE}}",
				ametysDescription: "{{i18n PLUGINS_EXTERNAL_DATA_UI_HELPER_QUERY_RESULTTYPE_DESC}}",
				items: [
					{boxLabel: "{{i18n PLUGINS_EXTERNAL_DATA_UI_HELPER_QUERY_RESULTTYPE_SIMPLE}}", name: 'resultType', inputValue: 'SIMPLE', width: 130},
					{boxLabel: "{{i18n PLUGINS_EXTERNAL_DATA_UI_HELPER_QUERY_RESULTTYPE_MULTIPLE}}", name: 'resultType', inputValue: 'MULTIPLE', checked: true, width: 130}
				]
			}
		];
	},
	
    /**
     * Init the fields with data
     * @param {Ext.form.Basic} form The form
     * @param {Object} data The data to initialize form with
     * @param {String} data.id The query identifier
     * @param {String} data.name The name of the query
     * @param {String} data.type The query type
     * @param {String} data.dataSourceId The datasource identifier
     * @param {String} data.description The description of the query
     * @param {String} data.resultType The type of query 'SIMPLE' or 'MULTIPLE'
     */
	initCommonFields: function (form, data)
	{
		form.findField('id').setValue(data.id);
		form.findField('name').setValue(data.name);
		form.findField('type').setValue(data.type);
		form.findField('dataSourceId').setValue(data.dataSourceId);
		form.findField('dataSourceId').disable();
		form.findField('description').setValue(data.description);
		
		var resultTypeGp = form.findField('resultTypeGroup');
		resultTypeGp.setValue({resultType: data.resultType});
	}
	
	
});