/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.externaldata.data.sql;

import java.util.Collections;
import java.util.Map;

import org.ametys.core.datasource.DataSourceClientInteraction.DataSourceType;
import org.ametys.plugins.externaldata.data.AbstractQuery;

/**
 * A query on a SQL server.
 */
public class SqlQuery extends AbstractQuery
{
    /** The query string. */
    protected String _queryString;
    
    @Override
    public DataSourceType getType()
    {
        return DataSourceType.SQL;
    }
    
    /**
     * Get the SQL query string.
     * @return the SQL query string.
     */
    public String getQueryString()
    {
        return _queryString;
    }
    
    /**
     * Set the query string.
     * @param queryString the query string
     */
    public void setQueryString(String queryString)
    {
        this._queryString = queryString;
    }
    
    @Override
    public Map<String, String> getParameters()
    {
        if (_parameters == null)
        {
            _parameters = _buildParameters(_queryString);
        }
        return _parameters;
    }
    
    @Override
    public Map<String, String> getAdditionalConfiguration()
    {
        return Collections.singletonMap("queryString", _queryString);
    }
}
