/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.kerberos;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ametys.core.authentication.AbstractCredentialProvider;
import org.ametys.core.authentication.NonBlockingCredentialProvider;
import org.ametys.core.user.UserIdentity;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosCredentialProvider
extends AbstractCredentialProvider
implements NonBlockingCredentialProvider,
Contextualizable,
Disposable {
    protected static final String __PARAM_KDC = "authentication.kerberos.kdc";
    protected static final String __PARAM_REALM = "authentication.kerberos.realm";
    protected static final String __PARAM_LOGIN = "authentication.kerberos.login";
    protected static final String __PARAM_PASSWORD = "authentication.kerberos.password";
    protected static final String __PARAM_IPRESTRICTION = "authentication.kerberos.ip-limitation-regexp";
    protected static final String __LOGIN_CONF_FILE = "jaas.conf";
    protected static final String __SKIP_KERBEROS_URL = "cocoon://_plugins/extra-user-management/userpopulations/credentialproviders/kerberos";
    protected static final String __SESSION_ATTRIBUTE_GSSCONTEXT = "GSSContext";
    private Context _context;
    private GSSCredential _gssCredential;
    private Pattern _ipRestriction;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public static LoginContext createLoginContext(final String realm, final String login, final String password) throws LoginException {
        Configuration loginConfig = null;
        if (System.getProperty("java.security.auth.login.config") == null) {
            loginConfig = new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    Map<String, String> options = Map.of("storeKey", "true", "isInitiator", "false");
                    return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
                }
            };
        }
        LoginContext loginContext = new LoginContext("kerberos", null, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(login + "@" + realm.toUpperCase());
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new RuntimeException("Invalid callback received during KerberosCredentialProvider initialization");
                }
            }
        }, loginConfig);
        loginContext.login();
        return loginContext;
    }

    public void init(String id, String cpModelId, Map<String, Object> paramValues, String label) throws Exception {
        super.init(id, cpModelId, paramValues, label);
        String ipRegexp = (String)paramValues.get(__PARAM_IPRESTRICTION);
        this._ipRestriction = StringUtils.isNotBlank((CharSequence)ipRegexp) ? Pattern.compile(ipRegexp) : null;
        String realm = (String)paramValues.get(__PARAM_REALM);
        String login = (String)paramValues.get(__PARAM_LOGIN);
        String password = (String)paramValues.get(__PARAM_PASSWORD);
        try {
            LoginContext loginContext = KerberosCredentialProvider.createLoginContext(realm, login, password);
            final GSSManager manager = GSSManager.getInstance();
            Callable<GSSCredential> action = new Callable<GSSCredential>(this){

                @Override
                public GSSCredential call() throws GSSException {
                    return manager.createCredential(null, Integer.MAX_VALUE, new Oid("1.3.6.1.5.5.2"), 2);
                }
            };
            this._gssCredential = Subject.callAs(loginContext.getSubject(), action);
        }
        catch (LoginException e) {
            throw new RuntimeException("Unable to initialize the KerberosCredentialProvider", e);
        }
    }

    public boolean nonBlockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) throws Exception {
        return true;
    }

    public boolean nonBlockingGrantAnonymousRequest() {
        Request request = ContextHelper.getRequest((Context)this._context);
        String url = (String)request.getAttribute("inWorkspaceURL");
        return "plugins/extra-user-management/userpopulations/credentialproviders/kerberos/skip".equals(url);
    }

    public UserIdentity nonBlockingGetUserIdentity(Redirector redirector) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        Response response = ContextHelper.getResponse((Context)this._context);
        if (!this._isIPAuthorized(request)) {
            return null;
        }
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Negotiate ")) {
            String tokenAnswer;
            String negotiateToken = authorization.substring("Negotiate ".length());
            if (negotiateToken.startsWith("TlRMTVNT")) {
                this.getLogger().debug("A user tried an NTLM token. Let's ignore it.");
                return null;
            }
            this.getLogger().debug("Received token {}", (Object)negotiateToken);
            byte[] token = Base64.decodeBase64((String)negotiateToken);
            Session session = request.getSession(true);
            GSSContext gssContext = (GSSContext)session.getAttribute(__SESSION_ATTRIBUTE_GSSCONTEXT);
            if (gssContext == null) {
                this.getLogger().debug("Creating new GSSContext");
                gssContext = GSSManager.getInstance().createContext(this._gssCredential);
                session.setAttribute(__SESSION_ATTRIBUTE_GSSCONTEXT, (Object)gssContext);
            } else {
                this.getLogger().debug("Using existing GSSContext");
            }
            byte[] kdcTokenAnswer = null;
            try {
                kdcTokenAnswer = gssContext.acceptSecContext(token, 0, token.length);
            }
            catch (GSSException e) {
                this._disposeContext(gssContext, session);
                throw e;
            }
            String string = tokenAnswer = kdcTokenAnswer != null ? Base64.encodeBase64String((byte[])kdcTokenAnswer) : null;
            if (!gssContext.isEstablished()) {
                response.setHeader("WWW-Authenticate", "Negotiate " + tokenAnswer);
                redirector.redirect(false, __SKIP_KERBEROS_URL);
                this.getLogger().debug("Need additionnal token. Sending answer token {}", (Object)tokenAnswer);
                return null;
            }
            GSSName gssSrcName = gssContext.getSrcName();
            if (gssSrcName == null) {
                this._disposeContext(gssContext, session);
                this.getLogger().debug("Reseting communication with client");
                response.setHeader("WWW-Authenticate", "Negotiate");
                redirector.redirect(false, __SKIP_KERBEROS_URL);
                return null;
            }
            if (tokenAnswer != null) {
                this.getLogger().debug("Sending answer token {}", (Object)tokenAnswer);
                response.setHeader("WWW-Authenticate", "Negotiate " + tokenAnswer);
            }
            String login = gssSrcName.toString();
            login = StringUtils.substringBefore((String)login, (String)"@");
            this._disposeContext(gssContext, session);
            this.getLogger().debug("User successfully identified '{}'", (Object)login);
            return new UserIdentity(login, null);
        }
        response.setHeader("WWW-Authenticate", "Negotiate");
        redirector.redirect(false, __SKIP_KERBEROS_URL);
        return null;
    }

    private void _disposeContext(GSSContext gssContext, Session session) throws GSSException {
        gssContext.dispose();
        session.removeAttribute(__SESSION_ATTRIBUTE_GSSCONTEXT);
    }

    private boolean _isIPAuthorized(Request request) {
        if (this._ipRestriction == null) {
            this.getLogger().debug("There is no IP restriction for Kerberos");
            return true;
        }
        String xff = request.getHeader("X-Forwarded-For");
        String ip = null;
        ip = xff != null ? xff.split(",")[0] : request.getRemoteAddr();
        if (!this._ipRestriction.matcher(ip).matches()) {
            this.getLogger().info("Ip '" + ip + "' was not authorized to use Kerberos authentication with filter " + this._ipRestriction.pattern());
            return false;
        }
        return true;
    }

    public void nonBlockingUserNotAllowed(Redirector redirector) {
        Request request = ContextHelper.getRequest((Context)this._context);
        Session session = request.getSession(false);
        if (session != null) {
            session.removeAttribute(__SESSION_ATTRIBUTE_GSSCONTEXT);
        }
    }

    public void nonBlockingUserAllowed(UserIdentity userIdentity, Redirector redirector) {
        Request request = ContextHelper.getRequest((Context)this._context);
        Session session = request.getSession(false);
        if (session != null) {
            session.removeAttribute(__SESSION_ATTRIBUTE_GSSCONTEXT);
        }
    }

    public void dispose() {
        try {
            this._gssCredential.dispose();
        }
        catch (GSSException e) {
            throw new RuntimeException("Unable to dispose the GSSCredential during KerberosCredentialProvider disposal", e);
        }
    }
}

